/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.registry;

import com.weibo.api.motan.registry.NotifyListener;
import com.weibo.api.motan.registry.support.command.CommandFailbackRegistry;
import com.weibo.api.motan.registry.support.command.CommandListener;
import com.weibo.api.motan.registry.support.command.CommandServiceManager;
import com.weibo.api.motan.registry.support.command.RpcCommand;
import com.weibo.api.motan.registry.support.command.RpcCommandUtil;
import com.weibo.api.motan.registry.support.command.ServiceListener;
import com.weibo.api.motan.registry.support.command.SinoCommandServiceManager;
import com.weibo.api.motan.registry.zookeeper.ZookeeperRegistry;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.util.LoggerUtil;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.I0Itec.zkclient.ZkClient;
import org.apache.commons.lang3.StringUtils;

public class CommandZookeeperRegistry
extends ZookeeperRegistry {
    private ConcurrentHashMap<URL, CommandServiceManager> commandManagerMap = new ConcurrentHashMap();

    public CommandZookeeperRegistry(URL url, ZkClient client) {
        super(url, client);
    }

    protected void doSubscribe(URL url, NotifyListener listener) {
        LoggerUtil.info((String)("CommandFailbackRegistry subscribe. url: " + url.toSimpleString()));
        URL urlCopy = url.createCopy();
        CommandServiceManager manager = this.getCommandServiceManager(urlCopy);
        manager.addNotifyListener(listener);
        this.subscribeService(urlCopy, (ServiceListener)manager);
        this.subscribeCommand(urlCopy, (CommandListener)manager);
        List<URL> urls = this.doDiscover(urlCopy);
        if (urls != null && urls.size() > 0) {
            this.notify(urlCopy, listener, urls);
        }
    }

    protected void doUnsubscribe(URL url, NotifyListener listener) {
        LoggerUtil.info((String)("CommandFailbackRegistry unsubscribe. url: " + url.toSimpleString()));
        URL urlCopy = url.createCopy();
        CommandServiceManager manager = this.commandManagerMap.get(urlCopy);
        manager.removeNotifyListener(listener);
        this.unsubscribeService(urlCopy, (ServiceListener)manager);
        this.unsubscribeCommand(urlCopy, (CommandListener)manager);
    }

    protected List<URL> doDiscover(URL url) {
        List finalResult;
        LoggerUtil.info((String)("CommandFailbackRegistry discover. url: " + url.toSimpleString()));
        URL urlCopy = url.createCopy();
        String commandStr = this.discoverCommand(urlCopy);
        RpcCommand rpcCommand = null;
        if (StringUtils.isNotEmpty((CharSequence)commandStr)) {
            rpcCommand = RpcCommandUtil.stringToCommand((String)commandStr);
        }
        LoggerUtil.info((String)("CommandFailbackRegistry discover command. commandStr: " + commandStr + ", rpccommand " + (rpcCommand == null ? "is null." : "is not null.")));
        if (rpcCommand != null) {
            rpcCommand.sort();
            CommandServiceManager manager = this.getCommandServiceManager(urlCopy);
            finalResult = manager.discoverServiceWithCommand(urlCopy, new HashMap(), rpcCommand);
            manager.setCommandCache(commandStr);
        } else {
            finalResult = this.discoverService(urlCopy);
        }
        LoggerUtil.info((String)("CommandFailbackRegistry discover size: " + finalResult.size() + ", result:" + finalResult.toString()));
        return finalResult;
    }

    private CommandServiceManager getCommandServiceManager(URL urlCopy) {
        CommandServiceManager manager = this.commandManagerMap.get(urlCopy);
        if (manager == null) {
            manager = new SinoCommandServiceManager(urlCopy);
            manager.setRegistry((CommandFailbackRegistry)this);
            CommandServiceManager manager1 = this.commandManagerMap.putIfAbsent(urlCopy, manager);
            if (manager1 != null) {
                manager = manager1;
            }
        }
        return manager;
    }
}

