/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.registry;

import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.api.motan.registry.CommandZookeeperRegistry;
import com.weibo.api.motan.registry.Registry;
import com.weibo.api.motan.registry.support.AbstractRegistryFactory;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.util.LoggerUtil;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.exception.ZkException;

@SpiMeta(name="commondZookeeper")
public class ZookeeperRegistryFactory
extends AbstractRegistryFactory {
    protected Registry createRegistry(URL registryUrl) {
        try {
            int timeout = registryUrl.getIntParameter(URLParamType.connectTimeout.getName(), URLParamType.connectTimeout.getIntValue());
            int sessionTimeout = registryUrl.getIntParameter(URLParamType.registrySessionTimeout.getName(), URLParamType.registrySessionTimeout.getIntValue());
            ZkClient zkClient = new ZkClient(registryUrl.getParameter("address"), sessionTimeout, timeout);
            return new CommandZookeeperRegistry(registryUrl, zkClient);
        }
        catch (ZkException e) {
            LoggerUtil.error((String)("[ZookeeperRegistry] fail to connect zookeeper, cause: " + e.getMessage()));
            throw e;
        }
    }
}

