package sinosoftgz.utils.data;


import ma.glasnost.orika.MapperFacade;
import ma.glasnost.orika.MapperFactory;
import ma.glasnost.orika.impl.DefaultMapperFactory;
import ma.glasnost.orika.metadata.ClassMapBuilder;
import ma.glasnost.orika.metadata.Type;
import ma.glasnost.orika.metadata.TypeFactory;

import java.util.List;
import java.util.Map;

/**
 * 用于操作Bean的工具类
 * 
 *
 *
 */
public class Beans {
	private static MapperFacade mapper;

	static {
		MapperFactory mapperFactory = new DefaultMapperFactory.Builder().build();
		mapper = mapperFactory.getMapperFacade();
	}

	/**
	 * 简单的复制出新类型对象（使用）.
	 *
	 * 通过source.getClass() 获得源Class
	 */
	public static <S, D> D map(S source, Class<D> destinationClass) {
		if(source == null) {
			return null;
		}
		return mapper.map(source, (Type<S>)TypeFactory.valueOf(source.getClass()), TypeFactory.valueOf(destinationClass));
	}


	/**
	 * 简单的复制出新对象列表到ArrayList
	 *
	 * 不建议使用mapper.mapAsList(Iterable<S>,Class<D>)接口, sourceClass需要反射，实在有点慢
	 */
	public static <S, D> List<D> mapList(Iterable<S> sourceList, Class<S> sourceClass, Class<D> destinationClass) {
		return mapper.mapAsList(sourceList, TypeFactory.valueOf(sourceClass), TypeFactory.valueOf(destinationClass));
	}

    /**
     * 简单的复制出新对象列表到ArrayList
     *
     * 不建议使用mapper.mapAsList(Iterable<S>,Class<D>)接口, sourceClass需要反射，实在有点慢
     */
    public static <S, D> List<D> mapList(Iterable<S> sourceList, Class<S> sourceClass, Class<D> destinationClass, Map<String, String> propMapping) {
        MapperFactory mapperFactory = new DefaultMapperFactory.Builder().build();
        ClassMapBuilder classMapBuilder = mapperFactory.classMap(TypeFactory.valueOf(sourceClass), TypeFactory.valueOf(destinationClass));
        for(Map.Entry<String, String> e : propMapping.entrySet()) {
            classMapBuilder.field(e.getKey(), e.getValue());
        }
        classMapBuilder.byDefault().register();
        return mapperFactory.getMapperFacade().mapAsList(sourceList, TypeFactory.valueOf(sourceClass), TypeFactory.valueOf(destinationClass));
    }

}
