package sinosoftgz.utils.data;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

/**
 * @author torvalds on 2018/9/16 1:33.
 * @version 1.0
 */
public class CopyUtil {
    private static List<String> copyPackageList = Arrays.asList(
            String.class.getPackage().getName(),
            BigDecimal.class.getPackage().getName(),
            Date.class.getPackage().getName());

    private static String idCopyProperty = "id";
    private static String idCopyPropertyMethod = "getId";

    /**
     * 对象拷贝，如果有关联对象只拷贝id属性
     *
     * @param source
     * @param destinationClass
     * @param <S>
     * @param <D>
     * @return
     */
    public static <S, D> D map(S source, Class<D> destinationClass) {
        if (source == null) {
            return null;
        }
        Class<?> sourceClass = source.getClass();
        Field[] destinationDeclaredFields = destinationClass.getDeclaredFields();
        D destinationObject = null;
        try {
            destinationObject = destinationClass.newInstance();
        } catch (Exception e) {
            e.printStackTrace();
        }
        Class destinationHolderClass = destinationClass;
        Class sourceHolderClass = sourceClass;
        while (destinationDeclaredFields != null && destinationDeclaredFields.length > 0) {
            Field.setAccessible(destinationDeclaredFields, true);
            for (Field destinationDeclaredField : destinationDeclaredFields) {
                try {
                    if (Collection.class.isAssignableFrom(destinationDeclaredField.getType())) {
                        destinationDeclaredField.set(destinationObject, null);
                        continue;
                    }
                    Field sourcedDclaredField = null;
                    Class holderSourceClass = sourceHolderClass;
                    while (true) {
                        try {
                            sourcedDclaredField = holderSourceClass.getDeclaredField(destinationDeclaredField.getName());
                        } catch (Exception e) {
                            if (holderSourceClass.getSuperclass() == null) {
                                break;
                            }
                            holderSourceClass = holderSourceClass.getSuperclass();
                        }
                        if (sourcedDclaredField != null) {
                            break;
                        }
                    }
                    sourcedDclaredField.setAccessible(true);
                    Object sourceFieldValue = sourcedDclaredField.get(source);
                    if (sourceFieldValue == null) {
                        String dclaredFieldName = sourcedDclaredField.getName();
                        String methodName = "get" + dclaredFieldName.substring(0, 1).toUpperCase() + dclaredFieldName.substring(1);
                        Method holderSourceClassDeclaredMethod = holderSourceClass.getDeclaredMethod(methodName);
                        sourceFieldValue = holderSourceClassDeclaredMethod.invoke(source);
                    }

                    if (sourceFieldValue == null) {
                        continue;
                    }
                    if (destinationDeclaredField.getType().isPrimitive() || copyPackageList.contains(destinationDeclaredField.getType().getPackage().getName())) {
                        destinationDeclaredField.set(destinationObject, sourceFieldValue);
                    } else {
                        Class<?> idClass = destinationDeclaredField.getType();
                        Object sourceIdFieldValue=null;
                        Field desidField = idClass.getDeclaredField(idCopyProperty);
                        try {

                            Field idField = sourceFieldValue.getClass().getDeclaredField(idCopyProperty);
                            idField.setAccessible(true);
                            sourceIdFieldValue = idField.get(sourceFieldValue);
                        }catch (Exception e){

                        }
                        if (sourceIdFieldValue == null) {
                            Method idClassDeclaredMethod = sourceFieldValue.getClass().getDeclaredMethod(idCopyPropertyMethod);
                            sourceIdFieldValue = idClassDeclaredMethod.invoke(sourceFieldValue);
                        }
                        if (sourceIdFieldValue == null) {
                            continue;
                        }
                        /**
                         * desidField存在则实例化属性拷贝对象
                         */
                        Object idObject = idClass.newInstance();
                        desidField.setAccessible(true);
                        desidField.set(idObject, sourceIdFieldValue);
                        destinationDeclaredField.set(destinationObject, idObject);
                    }

                } catch (Exception e) {
                    //没有对应的属性不处理
//                e.printStackTrace();
                }
            }

            destinationHolderClass = destinationHolderClass.getSuperclass();
//            sourceHolderClass = sourceHolderClass.getSuperclass();
            destinationDeclaredFields = destinationHolderClass.getDeclaredFields();
        }
        return destinationObject;
    }

    /**
     * 按原顺序拷贝
     *
     * @param sourceList
     * @param destinationHolderClass
     * @param <S>
     * @param <D>
     * @return
     */
    public static <S, D> List<D> mapList(Collection<S> sourceList, Class<D> destinationHolderClass) {
        List<D> destinationList = new CopyOnWriteArrayList<>();
        if (sourceList != null && !sourceList.isEmpty()) {
            sourceList.forEach(source -> {
                destinationList.add(map(source, destinationHolderClass));
            });
        }
        return destinationList;
    }

    /**
     * 无序拷贝，性能更好，适合不要求list顺序的场景
     *
     * @param sourceList
     * @param destinationHolderClass
     * @param <S>
     * @param <D>
     * @return
     */
    public static <S, D> List<D> parallelMapList(Collection<S> sourceList, Class<D> destinationHolderClass) {
        List<D> destinationList = new CopyOnWriteArrayList<>();
        if (sourceList != null && !sourceList.isEmpty()) {
            sourceList.stream().parallel().forEach(source -> {
                destinationList.add(map(source, destinationHolderClass));
            });
        }
        return destinationList;
    }
}
