package sinosoftgz.utils.data;

import java.nio.charset.Charset;

/**
 * 标准字符集
 * @author Liang Wenxu
 * @since 2018/12/18
 */
public enum StandardCharset {
    /**
     * Seven-bit ASCII, a.k.a. ISO646-US, a.k.a. the Basic Latin block of the
     * Unicode character set
     */
    US_ASCII("US-ASCII")
    /**
     * ISO Latin Alphabet No. 1, a.k.a. ISO-LATIN-1
     */
    , ISO_8859_1("ISO-8859-1")
    /**
     * Eight-bit UCS Transformation Format
     */
    , UTF_8("UTF-8")

    /**
     * Sixteen-bit UCS Transformation Format, big-endian byte order
     */
    , UTF_16BE("UTF-16BE")
    /**
     * Sixteen-bit UCS Transformation Format, little-endian byte order
     */
    , UTF_16LE("UTF-16LE")
    /**
     * Sixteen-bit UCS Transformation Format, byte order identified by an
     * optional byte-order mark
     */
    , UTF_16("UTF-16")
    ;


    private Charset charset;
    private String charsetName;

    StandardCharset(String charsetName) {
        this.charset = Charset.forName(charsetName);
        this.charsetName = charsetName;
    }

    public Charset value() {
        return this.charset;
    }

    /**
     * Returns the name of this enum constant, as contained in the
     * declaration.  This method may be overridden, though it typically
     * isn't necessary or desirable.  An enum type should override this
     * method when a more "programmer-friendly" string form exists.
     *
     * @return the name of this enum constant
     */
    @Override
    public String toString() {
        return this.charsetName;
    }
}
