package sinosoftgz.utils.data;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.xml.DomDriver;

import java.lang.reflect.Field;

/**
 * <p>XML工具类
 * <p>@date 2015年1月23日
 * <p>@version 1.0
 */
public class XmlUtil {

	/**
	 * 注解设置
	 * @param xs
	 * @param cls
	 */
	private static <T> void setAnnotations(XStream xs, Class<T> cls) {
		Field f[] = cls.getDeclaredFields();
		for (int i = 0; i < f.length; i++) {
			Field field = f[i];
			xs.processAnnotations(field.getType());
		}
	}

	/**
	 * Xml => Bean
	 * @param xml
	 * @param cls
	 * @param <T>
     * @return
     */
	public static <T> T toBean(String xml, Class<T> cls) {
		 XStream xstream = new XStream(new DomDriver("UTF-8"));
		xstream.processAnnotations(cls);
		return (T) xstream.fromXML(xml);
	}

	/**
	 * Xml => Bean
	 * @param xml
	 * @param cls
	 * @param <T>
     * @return
     */
	public static <T> T toBean(String xml, Class<?>... cls) {
		 XStream xstream = new XStream(new DomDriver("UTF-8"));
		for (Class<?> class1 : cls) {
			xstream.processAnnotations(class1);
		}
		return (T) xstream.fromXML(xml);
	}

	/**
	 * Bean => Xml
	 * @param obj
	 * @return
     */
	public static String toXml(Object obj) {
		 XStream xstream=new XStream(new DomDriver("UTF-8"));
		xstream.autodetectAnnotations(true);
		xstream.alias(obj.getClass().getSimpleName(), obj.getClass());
		String xml=xstream.toXML(obj);
		return xml;
	}
}
