/*
 * Decompiled with CFR 0.152.
 */
package com.wanda.finance.util;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class Utils {
    protected static final int[] DAYS_OF_EVERY_MONTH;

    static {
        int[] nArray = new int[13];
        nArray[1] = 31;
        nArray[2] = 29;
        nArray[3] = 31;
        nArray[4] = 30;
        nArray[5] = 31;
        nArray[6] = 30;
        nArray[7] = 31;
        nArray[8] = 31;
        nArray[9] = 30;
        nArray[10] = 31;
        nArray[11] = 30;
        nArray[12] = 31;
        DAYS_OF_EVERY_MONTH = nArray;
    }

    public static String formatDate(Object o, String format) {
        Date dt;
        String retStr;
        block7: {
            if (o == null) {
                return null;
            }
            retStr = "";
            try {
                dt = null;
                if (o instanceof Calendar) {
                    Calendar cal = (Calendar)o;
                    dt = cal.getTime();
                    break block7;
                }
                if (o instanceof Date) {
                    dt = (Date)o;
                    break block7;
                }
                if (o instanceof String) {
                    return o.toString();
                }
                System.out.println("formatDate:Error Object class=" + o.getClass());
                return "Error Object";
            }
            catch (Exception e) {
                e.printStackTrace();
                return retStr;
            }
        }
        SimpleDateFormat dFormat = new SimpleDateFormat(format);
        retStr = dFormat.format(dt);
        return retStr;
    }

    public static String formatNumber(Object d, String format) {
        if (d == null) {
            d = new Double(0.0);
        }
        String retStr = "0";
        try {
            DecimalFormat dFormat = new DecimalFormat(format);
            retStr = d instanceof String ? dFormat.format(Double.valueOf(d.toString())) : dFormat.format(d);
            return retStr;
        }
        catch (Exception e) {
            return retStr;
        }
    }

    public static long YuanToFen(double amt) {
        double d = amt * 100.0;
        return Math.round(d);
    }

    public static double FenToYuan(long amt) {
        double d = (double)amt / 100.0;
        return d;
    }

    public static String showYuan(Long amt) {
        if (amt == null) {
            return "0";
        }
        return Utils.formatNumber(Utils.FenToYuan(amt), "###,##0.00");
    }

    public static String cardForShow(String card) {
        String str = "";
        if (Utils.isNotBlank(card) && card.length() > 15) {
            str = String.valueOf(card.substring(0, 8)) + "******" + card.substring(card.length() - 4);
        }
        return str;
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        int i = 0;
        while (i < strLen) {
            if (!Character.isWhitespace(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isNotBlank(String str) {
        return !Utils.isBlank(str);
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(String str) {
        return !Utils.isEmpty(str);
    }

    public static boolean isValidDateyyyy_MM_dd(String yyyy_MM_dd) {
        int day;
        int month;
        int year;
        block13: {
            block12: {
                block11: {
                    block10: {
                        block9: {
                            block8: {
                                try {
                                    if (!Utils.isEmpty(yyyy_MM_dd) && !Utils.isEmpty(yyyy_MM_dd.trim())) break block8;
                                    return false;
                                }
                                catch (Exception e) {
                                    return false;
                                }
                            }
                            if (yyyy_MM_dd.length() == 10) break block9;
                            return false;
                        }
                        if (yyyy_MM_dd.split("-").length == 3) break block10;
                        return false;
                    }
                    year = Integer.parseInt(yyyy_MM_dd.substring(0, 4));
                    if (year > 0) break block11;
                    return false;
                }
                month = Integer.parseInt(yyyy_MM_dd.substring(5, 7));
                if (month > 0 && month <= 12) break block12;
                return false;
            }
            day = Integer.parseInt(yyyy_MM_dd.substring(8));
            if (day > 0 && day <= DAYS_OF_EVERY_MONTH[month]) break block13;
            return false;
        }
        return month != 2 || day != 29 || Utils.isGregorianLeapYear(year);
    }

    public static final boolean isGregorianLeapYear(int year) {
        return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
    }
}

