/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.rpc.enhancement.resttemplate;

import com.tencent.cloud.common.metadata.MetadataContextHolder;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedPluginContext;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedPluginRunner;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedPluginType;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedRequestContext;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedResponseContext;
import java.io.IOException;
import java.util.Map;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class EnhancedRestTemplateInterceptor
implements ClientHttpRequestInterceptor {
    private final EnhancedPluginRunner pluginRunner;

    public EnhancedRestTemplateInterceptor(EnhancedPluginRunner pluginRunner) {
        this.pluginRunner = pluginRunner;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        EnhancedPluginContext enhancedPluginContext = new EnhancedPluginContext();
        EnhancedRequestContext enhancedRequestContext = EnhancedRequestContext.builder().httpHeaders(request.getHeaders()).httpMethod(request.getMethod()).url(request.getURI()).build();
        enhancedPluginContext.setRequest(enhancedRequestContext);
        this.pluginRunner.run(EnhancedPluginType.PRE, enhancedPluginContext);
        long startMillis = System.currentTimeMillis();
        try {
            ClientHttpResponse response = execution.execute(request, body);
            enhancedPluginContext.setDelay(System.currentTimeMillis() - startMillis);
            EnhancedResponseContext enhancedResponseContext = EnhancedResponseContext.builder().httpStatus(response.getRawStatusCode()).httpHeaders(response.getHeaders()).build();
            enhancedPluginContext.setResponse(enhancedResponseContext);
            Map loadBalancerContext = MetadataContextHolder.get().getLoadbalancerMetadata();
            DefaultServiceInstance serviceInstance = new DefaultServiceInstance();
            serviceInstance.setServiceId(request.getURI().getHost());
            serviceInstance.setHost((String)loadBalancerContext.get("internal-callee-instance-host"));
            if (loadBalancerContext.get("internal-callee-instance-port") != null) {
                serviceInstance.setPort(Integer.parseInt((String)loadBalancerContext.get("internal-callee-instance-port")));
            }
            enhancedPluginContext.setServiceInstance((ServiceInstance)serviceInstance);
            this.pluginRunner.run(EnhancedPluginType.POST, enhancedPluginContext);
            ClientHttpResponse clientHttpResponse = response;
            return clientHttpResponse;
        }
        catch (IOException e) {
            enhancedPluginContext.setDelay(System.currentTimeMillis() - startMillis);
            enhancedPluginContext.setThrowable(e);
            this.pluginRunner.run(EnhancedPluginType.EXCEPTION, enhancedPluginContext);
            throw e;
        }
        finally {
            this.pluginRunner.run(EnhancedPluginType.FINALLY, enhancedPluginContext);
        }
    }
}

