/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.rpc.enhancement.scg;

import com.tencent.cloud.rpc.enhancement.plugin.EnhancedPluginContext;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedPluginRunner;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedPluginType;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedRequestContext;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedResponseContext;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.Response;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.core.Ordered;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class EnhancedGatewayGlobalFilter
implements GlobalFilter,
Ordered {
    private final EnhancedPluginRunner pluginRunner;

    public EnhancedGatewayGlobalFilter(EnhancedPluginRunner pluginRunner) {
        this.pluginRunner = pluginRunner;
    }

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        EnhancedPluginContext enhancedPluginContext = new EnhancedPluginContext();
        EnhancedRequestContext enhancedRequestContext = EnhancedRequestContext.builder().httpHeaders(exchange.getRequest().getHeaders()).httpMethod(exchange.getRequest().getMethod()).url(exchange.getRequest().getURI()).build();
        enhancedPluginContext.setRequest(enhancedRequestContext);
        this.pluginRunner.run(EnhancedPluginType.PRE, enhancedPluginContext);
        long startTime = System.currentTimeMillis();
        return chain.filter(exchange).doOnSubscribe(v -> {
            Response serviceInstanceResponse = (Response)exchange.getAttribute(ServerWebExchangeUtils.GATEWAY_LOADBALANCER_RESPONSE_ATTR);
            if (serviceInstanceResponse != null && serviceInstanceResponse.hasServer()) {
                ServiceInstance instance = (ServiceInstance)serviceInstanceResponse.getServer();
                enhancedPluginContext.setServiceInstance(instance);
            }
        }).doOnSuccess(v -> {
            enhancedPluginContext.setDelay(System.currentTimeMillis() - startTime);
            EnhancedResponseContext enhancedResponseContext = EnhancedResponseContext.builder().httpStatus(exchange.getResponse().getRawStatusCode()).httpHeaders(exchange.getResponse().getHeaders()).build();
            enhancedPluginContext.setResponse(enhancedResponseContext);
            this.pluginRunner.run(EnhancedPluginType.POST, enhancedPluginContext);
        }).doOnError(t -> {
            enhancedPluginContext.setDelay(System.currentTimeMillis() - startTime);
            enhancedPluginContext.setThrowable((Throwable)t);
            this.pluginRunner.run(EnhancedPluginType.EXCEPTION, enhancedPluginContext);
        }).doFinally(v -> this.pluginRunner.run(EnhancedPluginType.FINALLY, enhancedPluginContext));
    }

    public int getOrder() {
        return 10151;
    }
}

