/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbcx;

import com.informix.jdbcx.IfxConnectionPoolDataSource;
import com.informix.jdbcx.IfxReUsableConnection;
import com.informix.jdbcx.IfxSqliConnReUsableConnection;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Vector;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public class IfxPooledConnection
implements PooledConnection {
    private Vector listeners = null;
    private Properties DSProp = null;
    private IfxReUsableConnection conn = null;
    private IfxConnectionPoolDataSource cpds = null;
    protected long timeInPool = 0L;
    Trace trace = null;

    public IfxPooledConnection() throws SQLException {
        this.listeners = new Vector();
        this.DSProp = null;
        this.conn = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IfxPooledConnection(String string, String string2, IfxConnectionPoolDataSource ifxConnectionPoolDataSource) throws SQLException {
        this.cpds = ifxConnectionPoolDataSource;
        this.conn = null;
        this.listeners = new Vector();
        Properties properties = this.DSProp = this.cpds.getDsProperties();
        synchronized (properties) {
            int n;
            String string3 = this.DSProp.getProperty("IFMX_CPM_MAX_CONNECTIONS");
            if (string3 == null || string3.length() == 0) {
                string3 = "-1";
            }
            if ((n = Integer.parseInt(string3)) != -1 && this.cpds.getConnectionCount() >= n) {
                throw IfxErrMsg.getLocSQLException((int)-79831, (String)this.cpds.getIfxCLIENT_LOCALE());
            }
            this.establishConnection(string, string2);
            this.cpds.addToReferenceList(this);
        }
    }

    public Connection getConnection() throws SQLException {
        return (Connection)((Object)this.conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        if (this.conn == null) {
            return;
        }
        IfxConnectionPoolDataSource ifxConnectionPoolDataSource = this.cpds;
        synchronized (ifxConnectionPoolDataSource) {
            try {
                this.conn.hardClose();
            }
            finally {
                this.cpds.removeFromReferenceList(this);
            }
        }
        this.conn = null;
    }

    public synchronized void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.listeners.addElement(connectionEventListener);
    }

    public synchronized void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.listeners.removeElement(connectionEventListener);
    }

    void notifyListeners() throws SQLException {
        this.notifyListenersOfErrors(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyListenersOfErrors(SQLException sQLException) throws SQLException {
        int n = 0;
        int n2 = 0;
        ConnectionEventListener connectionEventListener = null;
        Vector vector = null;
        Vector vector2 = this.listeners;
        synchronized (vector2) {
            vector = (Vector)this.listeners.clone();
        }
        n = vector.size();
        for (n2 = 0; n2 < n; ++n2) {
            connectionEventListener = (ConnectionEventListener)vector.elementAt(n2);
            if (sQLException != null) {
                connectionEventListener.connectionErrorOccurred(new ConnectionEvent(this, sQLException));
                throw sQLException;
            }
            connectionEventListener.connectionClosed(new ConnectionEvent(this));
        }
    }

    private void establishConnection(String string, String string2) throws SQLException {
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        string5 = this.DSProp.getProperty("IFXHOST");
        string6 = this.DSProp.getProperty("PORTNO");
        if (string5 != null && string6 != null) {
            string3 = string5 + ":" + string6;
        }
        if ((string4 = this.DSProp.getProperty("DATABASE")) != null) {
            try {
                this.DSProp.remove("DATABASE");
                this.conn = this.getClientServerReUsable(string, string2, string3, string4);
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (Exception exception) {
                throw IfxErrMsg.getLocSQLException((int)-79716, (String)exception.toString(), (String)this.cpds.getIfxCLIENT_LOCALE());
            }
            finally {
                this.DSProp.setProperty("DATABASE", string4);
            }
        } else {
            throw IfxErrMsg.getLocSQLException((int)-79716, (String)"Missing DATABASE Property", (String)this.cpds.getIfxCLIENT_LOCALE());
        }
    }

    public void setTimeInPool() {
        this.timeInPool = System.currentTimeMillis();
    }

    private IfxReUsableConnection getClientServerReUsable(String string, String string2, String string3, String string4) throws SQLException {
        if (!this.cpds.checkIsDirect()) {
            IfxSqliConnReUsableConnection ifxSqliConnReUsableConnection = null;
            ifxSqliConnReUsableConnection = new IfxSqliConnReUsableConnection(string, string2, this, string3, this.DSProp, string4);
            return ifxSqliConnReUsableConnection;
        }
        Constructor constructor = this.cpds.getReUsableCons();
        Object[] objectArray = new Object[]{this, string3, this.DSProp, string4};
        if (constructor != null) {
            try {
                this.conn = (IfxReUsableConnection)constructor.newInstance(objectArray);
                return this.conn;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw IfxErrMsg.getLocSQLException((int)-79716, (String)exception.toString());
            }
        }
        try {
            String string5 = "com.informix.jdbcx.IfxDirConnReUsableConnection";
            Class<?> clazz = Class.forName(string5);
            if (string3 == null) {
                string3 = "";
            }
            if (string4 == null) {
                string4 = "";
            }
            Class[] classArray = new Class[]{this.getClass(), string3.getClass(), this.DSProp.getClass(), string4.getClass()};
            Constructor<?> constructor2 = clazz.getConstructor(classArray);
            this.cpds.setReUsableCons(constructor2);
            this.conn = (IfxReUsableConnection)constructor2.newInstance(objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw IfxErrMsg.getLocSQLException((int)-79716, (String)exception.toString());
        }
        return this.conn;
    }
}

