/*
 * Decompiled with CFR 0.152.
 */
package com.xingyuv.captcha.util;

import com.xingyuv.captcha.model.vo.PointVO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtil {
    private static Logger logger = LoggerFactory.getLogger(JsonUtil.class);

    public static List<PointVO> parseArray(String text, Class<PointVO> clazz) {
        if (text == null) {
            return null;
        }
        String[] arr = text.replaceFirst("\\[", "").replaceFirst("\\]", "").split("\\}");
        ArrayList<PointVO> ret = new ArrayList<PointVO>(arr.length);
        for (String s : arr) {
            ret.add(JsonUtil.parseObject(s, PointVO.class));
        }
        return ret;
    }

    public static PointVO parseObject(String text, Class<PointVO> clazz) {
        if (text == null) {
            return null;
        }
        try {
            PointVO ret = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return ret.parse(text);
        }
        catch (Exception ex) {
            logger.error("json\u89e3\u6790\u5f02\u5e38", (Throwable)ex);
            return null;
        }
    }

    public static String toJSONString(Object object) {
        if (object == null) {
            return "{}";
        }
        if (object instanceof PointVO) {
            PointVO t2 = (PointVO)object;
            return t2.toJsonString();
        }
        if (object instanceof List) {
            List list = (List)object;
            StringBuilder buf = new StringBuilder("[");
            list.forEach(t -> buf.append(t.toJsonString()).append(","));
            return buf.deleteCharAt(buf.lastIndexOf(",")).append("]").toString();
        }
        if (object instanceof Map) {
            return ((Map)object).entrySet().toString();
        }
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u8f93\u5165\u7c7b\u578b:" + object.getClass().getSimpleName());
    }
}

