/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.flow.parallel.strategy;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjUtil;
import com.yomahub.liteflow.enums.ParallelStrategyEnum;
import com.yomahub.liteflow.exception.ParallelExecutorCreateException;
import com.yomahub.liteflow.flow.parallel.strategy.ParallelStrategyExecutor;
import com.yomahub.liteflow.log.LFLog;
import com.yomahub.liteflow.log.LFLoggerManager;
import com.yomahub.liteflow.spi.holder.ContextAwareHolder;
import java.util.Map;

public class ParallelStrategyHelper {
    private final LFLog LOG = LFLoggerManager.getLogger(ParallelStrategyHelper.class);
    private final Map<ParallelStrategyEnum, ParallelStrategyExecutor> strategyExecutorMap = MapUtil.newConcurrentHashMap();

    private ParallelStrategyHelper() {
    }

    public static ParallelStrategyHelper loadInstance() {
        return Holder.INSTANCE;
    }

    private ParallelStrategyExecutor getParallelStrategyExecutor(ParallelStrategyEnum parallelStrategyEnum) {
        try {
            ParallelStrategyExecutor strategyExecutor = this.strategyExecutorMap.get((Object)parallelStrategyEnum);
            if (ObjUtil.isNotNull((Object)strategyExecutor)) {
                return strategyExecutor;
            }
            Class<?> executorClass = Class.forName(parallelStrategyEnum.getClazz().getName());
            strategyExecutor = (ParallelStrategyExecutor)ContextAwareHolder.loadContextAware().registerBean(executorClass);
            this.strategyExecutorMap.put(parallelStrategyEnum, strategyExecutor);
            return strategyExecutor;
        }
        catch (Exception e) {
            this.LOG.error(e.getMessage());
            throw new ParallelExecutorCreateException(e.getMessage());
        }
    }

    public ParallelStrategyExecutor buildParallelExecutor(ParallelStrategyEnum parallelStrategyEnum) {
        if (ObjUtil.isNull((Object)((Object)parallelStrategyEnum))) {
            return this.buildParallelExecutor();
        }
        return this.getParallelStrategyExecutor(parallelStrategyEnum);
    }

    public ParallelStrategyExecutor buildParallelExecutor() {
        return this.buildParallelExecutor(ParallelStrategyEnum.ALL);
    }

    public void clearStrategyExecutorMap() {
        if (MapUtil.isNotEmpty(this.strategyExecutorMap)) {
            this.strategyExecutorMap.clear();
        }
    }

    private static class Holder {
        static final ParallelStrategyHelper INSTANCE = new ParallelStrategyHelper();

        private Holder() {
        }
    }
}

