/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.config;

import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="spring.boot.admin")
public class AdminServerProperties {
    private String contextPath = "";
    private MonitorProperties monitor = new MonitorProperties();
    private RoutesProperties routes = new RoutesProperties();

    public void setContextPath(String pathPrefix) {
        if (!pathPrefix.startsWith("/") || pathPrefix.endsWith("/")) {
            throw new IllegalArgumentException("ContextPath must start with '/' and not end with '/'");
        }
        this.contextPath = pathPrefix;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public MonitorProperties getMonitor() {
        return this.monitor;
    }

    public RoutesProperties getRoutes() {
        return this.routes;
    }

    public static class RoutesProperties {
        private String[] endpoints = new String[]{"env", "metrics", "trace", "dump", "jolokia", "info", "trace", "logfile", "refresh", "flyway", "liquibase", "heapdump"};

        public String[] getEndpoints() {
            return this.endpoints;
        }

        public void setEndpoints(String[] endpoints) {
            this.endpoints = endpoints;
        }
    }

    public static class MonitorProperties {
        private long period = 10000L;
        private long statusLifetime = 10000L;

        public void setPeriod(long period) {
            this.period = period;
        }

        public long getPeriod() {
            return this.period;
        }

        public void setStatusLifetime(long statusLifetime) {
            this.statusLifetime = statusLifetime;
        }

        public long getStatusLifetime() {
            return this.statusLifetime;
        }
    }
}

