/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.discovery;

import de.codecentric.boot.admin.discovery.ServiceInstanceConverter;
import de.codecentric.boot.admin.model.Application;
import java.net.URI;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.web.util.UriComponentsBuilder;

public class DefaultServiceInstanceConverter
implements ServiceInstanceConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultServiceInstanceConverter.class);
    private static final String KEY_MANAGEMENT_PORT = "management.port";
    private static final String KEY_MANAGEMENT_PATH = "management.context-path";
    private static final String KEY_HEALTH_PATH = "health.path";
    private String managementContextPath = "";
    private String healthEndpointPath = "health";

    @Override
    public Application convert(ServiceInstance instance) {
        Map<String, String> metadata;
        URI serviceUrl;
        URI managementUrl;
        LOGGER.debug("Converting service '{}' running at '{}' with metadata {}", new Object[]{instance.getServiceId(), instance.getUri(), instance.getMetadata()});
        Application.Builder builder = Application.create(instance.getServiceId());
        URI healthUrl = this.getHealthUrl(instance);
        if (healthUrl != null) {
            builder.withHealthUrl(healthUrl.toString());
        }
        if ((managementUrl = this.getManagementUrl(instance)) != null) {
            builder.withManagementUrl(managementUrl.toString());
        }
        if ((serviceUrl = this.getServiceUrl(instance)) != null) {
            builder.withServiceUrl(serviceUrl.toString());
        }
        if ((metadata = this.getMetadata(instance)) != null) {
            builder.withMetadata(metadata);
        }
        return builder.build();
    }

    protected URI getHealthUrl(ServiceInstance instance) {
        String healthPath = StringUtils.defaultIfEmpty((String)((String)instance.getMetadata().get(KEY_HEALTH_PATH)), (String)this.healthEndpointPath);
        healthPath = StringUtils.stripStart((String)healthPath, (String)"/");
        return UriComponentsBuilder.fromUri((URI)this.getManagementUrl(instance)).pathSegment(new String[]{healthPath}).build().toUri();
    }

    protected URI getManagementUrl(ServiceInstance instance) {
        String managamentPath = StringUtils.defaultIfEmpty((String)((String)instance.getMetadata().get(KEY_MANAGEMENT_PATH)), (String)this.managementContextPath);
        managamentPath = StringUtils.stripStart((String)managamentPath, (String)"/");
        URI serviceUrl = this.getServiceUrl(instance);
        String managamentPort = StringUtils.defaultIfEmpty((String)((String)instance.getMetadata().get(KEY_MANAGEMENT_PORT)), (String)String.valueOf(serviceUrl.getPort()));
        return UriComponentsBuilder.fromUri((URI)serviceUrl).port(managamentPort).pathSegment(new String[]{managamentPath}).build().toUri();
    }

    protected URI getServiceUrl(ServiceInstance instance) {
        return instance.getUri();
    }

    protected Map<String, String> getMetadata(ServiceInstance instance) {
        return instance.getMetadata();
    }

    public void setManagementContextPath(String managementContextPath) {
        this.managementContextPath = managementContextPath;
    }

    public String getManagementContextPath() {
        return this.managementContextPath;
    }

    public void setHealthEndpointPath(String healthEndpointPath) {
        this.healthEndpointPath = healthEndpointPath;
    }

    public String getHealthEndpointPath() {
        return this.healthEndpointPath;
    }
}

