/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.web.autoconfiguration;

import ins.framework.web.swagger.SwaggerConfigProps;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.ApiKey;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.Contact;
import springfox.documentation.service.Parameter;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableSwagger2
@EnableConfigurationProperties(value={SwaggerConfigProps.class})
@ConditionalOnProperty(value={"framework.swagger.enabled"}, havingValue="true", matchIfMissing=true)
public class SwaggerAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(SwaggerAutoConfiguration.class);
    private SwaggerConfigProps config;

    public SwaggerAutoConfiguration(SwaggerConfigProps config) {
        this.config = config;
    }

    private static List<ApiKey> securitySchemes() {
        ArrayList<ApiKey> apiKeys = new ArrayList<ApiKey>();
        apiKeys.add(new ApiKey("Authorization", "Authorization", "header"));
        return apiKeys;
    }

    private static List<SecurityContext> securityContexts() {
        ArrayList<SecurityContext> securityContexts = new ArrayList<SecurityContext>();
        securityContexts.add(SecurityContext.builder().securityReferences(SwaggerAutoConfiguration.defaultAuth()).forPaths(PathSelectors.regex((String)"^(?!auth).*$")).build());
        return securityContexts;
    }

    private static List<SecurityReference> defaultAuth() {
        ArrayList<SecurityReference> securityReferences = new ArrayList<SecurityReference>();
        securityReferences.add(new SecurityReference("Authorization", new AuthorizationScope[]{new AuthorizationScope("global", "accessEverything")}));
        return securityReferences;
    }

    private List<Parameter> defaultParameters() {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        if (this.config.getParameter() != null) {
            for (SwaggerConfigProps.SwaggerParameter param : this.config.getParameter()) {
                ParameterBuilder parameterBuilder = new ParameterBuilder();
                parameterBuilder.name(param.getName()).description(param.getDescription()).defaultValue(param.getDefaultValue()).modelRef((ModelReference)new ModelRef(param.getModelRef())).parameterType(param.getParamType()).required(param.isRequired()).build();
                parameters.add(parameterBuilder.build());
            }
        }
        return parameters;
    }

    @Bean
    @ConditionalOnMissingBean
    public Docket createRestApi() {
        log.info("Init swagger");
        return new Docket(DocumentationType.SWAGGER_2).apiInfo(this.apiInfo()).select().apis(RequestHandlerSelectors.withMethodAnnotation(ApiOperation.class)).paths(PathSelectors.any()).build().useDefaultResponseMessages(this.config.isUseDefaultResponseMessages()).globalOperationParameters(this.defaultParameters()).securitySchemes(SwaggerAutoConfiguration.securitySchemes()).securityContexts(SwaggerAutoConfiguration.securityContexts());
    }

    private ApiInfo apiInfo() {
        Contact contact = this.config.getContact();
        if (contact == null) {
            contact = new Contact("", "", "");
        }
        return new ApiInfoBuilder().title(this.config.getTitle()).description(this.config.getDescription()).termsOfServiceUrl(this.config.getTermsOfServiceUrl()).contact(contact).version(this.config.getVersion()).build();
    }
}

