/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.web.autoconfiguration;

import ins.framework.auth.util.JwtAuthUtil;
import ins.framework.lang.Springs;
import ins.framework.web.exception.CustomizeErrorController;
import ins.framework.web.i18n.LocaleMessageService;
import ins.framework.web.util.JwtUtil;
import java.util.List;
import javax.servlet.Servlet;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.ResourceProperties;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.error.BasicErrorController;
import org.springframework.boot.autoconfigure.web.servlet.error.ErrorViewResolver;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.DispatcherServlet;

@Configuration
@ConditionalOnWebApplication
@ConditionalOnClass(value={Servlet.class, DispatcherServlet.class})
@AutoConfigureBefore(value={WebMvcAutoConfiguration.class})
@EnableConfigurationProperties(value={ResourceProperties.class})
public class WebAutoConfiguration {
    private final ServerProperties serverProperties;
    private final List<ErrorViewResolver> errorViewResolvers;

    public WebAutoConfiguration(ServerProperties serverProperties, ObjectProvider<List<ErrorViewResolver>> errorViewResolversProvider) {
        this.serverProperties = serverProperties;
        this.errorViewResolvers = (List)errorViewResolversProvider.getIfAvailable();
    }

    @Bean
    @ConditionalOnMissingBean
    public BasicErrorController customizeErrorController(ErrorAttributes errorAttributes) {
        return new CustomizeErrorController(errorAttributes, this.serverProperties.getError(), this.errorViewResolvers);
    }

    @Bean
    @ConditionalOnMissingBean
    JwtAuthUtil jwtAuthUtil() {
        return new JwtAuthUtil();
    }

    @Bean
    @ConditionalOnMissingBean
    LocaleMessageService localeMessageService() {
        return new LocaleMessageService();
    }

    @Bean
    @ConditionalOnMissingBean
    Springs springs() {
        return new Springs();
    }

    @Bean
    @ConditionalOnMissingBean
    JwtUtil jwtUtil() {
        return new JwtUtil();
    }
}

