/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.web.filter;

import ins.framework.utils.Uuids;
import ins.framework.web.filter.support.RequestInfoUtils;
import ins.framework.web.filter.support.XssHttpServletRequestWrapper;
import java.io.IOException;
import java.util.Date;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class WebAppFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(WebAppFilter.class);
    public static final String REQUEST_START_TIME = "REQUEST_START_TIME";
    public static final String TRACE_ID = "TRACE_ID";
    public static final String REQUEST_TIME = "REQUEST_TIME";
    public static final String SERVER_NAME = "SERVER_NAME";
    public static final String SERVER_PORT = "SERVER_PORT";
    public static final String REMOTE_HOST = "REMOTE_HOST";
    public static final String REMOTE_USER = "REMOTE_USER";
    private boolean useMDC = true;
    private boolean printRequest;

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        try {
            Date requestTime = new Date();
            String traceId = request.getParameter(TRACE_ID);
            if (StringUtils.isBlank((CharSequence)traceId)) {
                traceId = Uuids.longUuid();
            }
            request.setAttribute(REQUEST_START_TIME, (Object)requestTime);
            request.setAttribute(REQUEST_TIME, (Object)requestTime);
            request.setAttribute(TRACE_ID, (Object)traceId);
            if (this.useMDC) {
                MDC.put((String)TRACE_ID, (String)traceId);
                MDC.put((String)REQUEST_TIME, (String)requestTime.toString());
            }
            if (request instanceof HttpServletRequest) {
                HttpServletRequest req = (HttpServletRequest)request;
                String remoteUser = "" + req.getRemoteUser();
                if (this.useMDC) {
                    MDC.put((String)SERVER_NAME, (String)req.getServerName());
                    MDC.put((String)SERVER_PORT, (String)("" + req.getServerPort()));
                    MDC.put((String)REMOTE_HOST, (String)req.getRemoteHost());
                    MDC.put((String)REMOTE_USER, (String)remoteUser);
                }
                request.setAttribute(SERVER_NAME, (Object)req.getServerName());
                request.setAttribute(SERVER_PORT, (Object)req.getServerPort());
                request.setAttribute(REMOTE_HOST, (Object)req.getRemoteHost());
                request.setAttribute(REMOTE_USER, (Object)remoteUser);
                if (this.printRequest) {
                    log.debug(RequestInfoUtils.requestToString(req));
                }
            }
            XssHttpServletRequestWrapper xssRequest = new XssHttpServletRequestWrapper((HttpServletRequest)request);
            filterChain.doFilter((ServletRequest)xssRequest, response);
        }
        finally {
            if (this.useMDC) {
                MDC.clear();
            }
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        log.info("===================WebAppFilter init===============");
        this.useMDC = Boolean.parseBoolean(WebAppFilter.getInitParameterWithDefalut(filterConfig, "useMDC", "true"));
        this.printRequest = Boolean.parseBoolean(WebAppFilter.getInitParameterWithDefalut(filterConfig, "printRequest", "false"));
    }

    private static String getInitParameterWithDefalut(FilterConfig filterConfig, String name, String defaultValue) {
        String value = filterConfig.getInitParameter(name);
        if (StringUtils.isEmpty((CharSequence)value)) {
            value = defaultValue;
        }
        return value;
    }
}

