/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.web.filter.support;

import ins.framework.lang.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.builder.ToStringBuilder;

public final class RequestInfoUtils {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String SEP_LINE = Strings.newString((char)'*', (int)70);
    private static final String SEP_PART = Strings.newString((char)'-', (int)30);

    private RequestInfoUtils() {
    }

    public static String requestToString(HttpServletRequest request) {
        StringBuilder sb = new StringBuilder();
        sb.append(LINE_SEPARATOR);
        sb.append(SEP_LINE).append(LINE_SEPARATOR);
        sb.append(SEP_PART).append("Basic").append(SEP_PART).append(LINE_SEPARATOR);
        sb.append("request.getRequestURL()=").append(request.getRequestURL()).append(LINE_SEPARATOR);
        sb.append("request.getAuthType()=").append(request.getAuthType()).append(LINE_SEPARATOR);
        sb.append("request.getCharacterEncoding()=").append(request.getCharacterEncoding()).append(LINE_SEPARATOR);
        sb.append("request.getContentLength()=").append(request.getContentLength()).append(LINE_SEPARATOR);
        sb.append("request.getContentLengthLong()=").append(request.getContentLengthLong()).append(LINE_SEPARATOR);
        sb.append("request.getContentType()=").append(request.getContentType()).append(LINE_SEPARATOR);
        sb.append("request.getContextPath()=").append(request.getContextPath()).append(LINE_SEPARATOR);
        sb.append("request.getLocalAddr()=").append(request.getLocalAddr()).append(LINE_SEPARATOR);
        sb.append("request.getLocalName()=").append(request.getLocalName()).append(LINE_SEPARATOR);
        sb.append("request.getLocalPort()=").append(request.getLocalPort()).append(LINE_SEPARATOR);
        sb.append("request.getMethod()=").append(request.getMethod()).append(LINE_SEPARATOR);
        sb.append("request.getPathInfo()=").append(request.getPathInfo()).append(LINE_SEPARATOR);
        sb.append("request.getPathTranslated()=").append(request.getPathTranslated()).append(LINE_SEPARATOR);
        sb.append("request.getProtocol()=").append(request.getProtocol()).append(LINE_SEPARATOR);
        sb.append("request.getQueryString()=").append(request.getQueryString()).append(LINE_SEPARATOR);
        sb.append("request.getRemoteAddr()=").append(request.getRemoteAddr()).append(LINE_SEPARATOR);
        sb.append("request.getRemoteHost()=").append(request.getRemoteHost()).append(LINE_SEPARATOR);
        sb.append("request.getRemotePort()=").append(request.getRemotePort()).append(LINE_SEPARATOR);
        sb.append("request.getRemoteUser()=").append(request.getRemoteUser()).append(LINE_SEPARATOR);
        sb.append("request.getRequestURI()=").append(request.getRequestURI()).append(LINE_SEPARATOR);
        sb.append("request.getScheme()=").append(request.getScheme()).append(LINE_SEPARATOR);
        sb.append("request.getServerName()=").append(request.getServerName()).append(LINE_SEPARATOR);
        sb.append("request.getServerPort()=").append(request.getServerPort()).append(LINE_SEPARATOR);
        sb.append("request.getServletPath()=").append(request.getServletPath()).append(LINE_SEPARATOR);
        sb.append("request.getUserPrincipal()=").append(request.getUserPrincipal()).append(LINE_SEPARATOR);
        sb.append(SEP_PART).append("Header").append(SEP_PART).append(LINE_SEPARATOR);
        Enumeration headerNames = request.getHeaderNames();
        ArrayList<Object> names = new ArrayList<Object>();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            names.add(name);
        }
        Collections.sort(names);
        for (Object name : names) {
            Enumeration enumeration = request.getHeaders((String)name);
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                sb.append("Header[").append((String)name).append("]=").append(string).append(LINE_SEPARATOR);
            }
        }
        sb.append(SEP_PART).append("Attribute").append(SEP_PART).append(LINE_SEPARATOR);
        Enumeration attributeNames = request.getAttributeNames();
        names.clear();
        while (attributeNames.hasMoreElements()) {
            Object name;
            name = (String)attributeNames.nextElement();
            names.add(name);
        }
        Collections.sort(names);
        for (String string : names) {
            Object object = request.getAttribute(string);
            String value = "";
            value = object == null ? "" : (object instanceof String ? (String)object : (object.getClass().isPrimitive() ? (String)object : ToStringBuilder.reflectionToString((Object)object)));
            sb.append("Attribute[").append(string).append("]=").append(value).append(LINE_SEPARATOR);
        }
        sb.append(SEP_PART).append("Parameter").append(SEP_PART).append(LINE_SEPARATOR);
        Enumeration parameterNames = request.getParameterNames();
        names.clear();
        while (parameterNames.hasMoreElements()) {
            String string = (String)parameterNames.nextElement();
            names.add(string);
        }
        Collections.sort(names);
        for (String string : names) {
            String[] values = request.getParameterValues(string);
            for (int i = 0; i < values.length; ++i) {
                String value = values[i];
                sb.append("Parameter[").append(string).append("]=").append(value).append(LINE_SEPARATOR);
            }
        }
        sb.append(SEP_LINE).append(LINE_SEPARATOR);
        return sb.toString();
    }
}

