/*
 * Decompiled with CFR 0.152.
 */
package io.bit3.jsass.type;

import io.bit3.jsass.type.SassValue;
import java.util.stream.IntStream;
import org.apache.commons.lang3.text.translate.CharSequenceTranslator;
import org.apache.commons.lang3.text.translate.EntityArrays;
import org.apache.commons.lang3.text.translate.JavaUnicodeEscaper;
import org.apache.commons.lang3.text.translate.LookupTranslator;

public class SassString
implements CharSequence,
SassValue {
    public static final int TYPE = 3;
    public static final char DEFAULT_QUOTE_CHARACTER = '\"';
    private String value;
    private boolean quoted = true;
    private char quote = (char)34;

    public SassString(String value) {
        this.value = value;
    }

    public SassString(String value, boolean quoted) {
        this.value = value;
        this.quoted = quoted;
    }

    public SassString(String value, boolean quoted, char quote) {
        this.value = value;
        this.quoted = quoted;
        this.quote = quote;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isQuoted() {
        return this.quoted;
    }

    public void setQuoted(boolean quoted) {
        this.quoted = quoted;
    }

    public char getQuote() {
        return this.quote;
    }

    public void setQuote(char quote) {
        this.quote = quote;
    }

    public static String escape(String value) {
        return SassString.escape(value, '\"');
    }

    public static String escape(String value, char quote) {
        CharSequenceTranslator escape = new LookupTranslator((CharSequence[][])new String[][]{{Character.toString(quote), "\\" + quote}, {"\\", "\\\\"}}).with(new CharSequenceTranslator[]{new LookupTranslator((CharSequence[][])EntityArrays.JAVA_CTRL_CHARS_ESCAPE())}).with(new CharSequenceTranslator[]{JavaUnicodeEscaper.outsideOf((int)32, (int)127)});
        return quote + escape.translate((CharSequence)value) + quote;
    }

    @Override
    public int length() {
        return this.value.length();
    }

    @Override
    public char charAt(int index) {
        return this.value.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.value.subSequence(start, end);
    }

    @Override
    public IntStream chars() {
        return this.value.chars();
    }

    @Override
    public IntStream codePoints() {
        return this.value.codePoints();
    }

    @Override
    public String toString() {
        return this.quoted ? SassString.escape(this.value, this.quote) : this.value;
    }
}

