/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.servicecatalog.client.internal;

import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.extension.ExtensibleResourceAdapter;
import io.fabric8.servicecatalog.api.model.ClusterServiceClass;
import io.fabric8.servicecatalog.api.model.ClusterServicePlan;
import io.fabric8.servicecatalog.api.model.ClusterServicePlanList;
import io.fabric8.servicecatalog.api.model.ServiceInstance;
import io.fabric8.servicecatalog.api.model.ServiceInstanceBuilder;
import io.fabric8.servicecatalog.api.model.ServiceInstanceFluent;
import io.fabric8.servicecatalog.client.ServiceCatalogClient;
import io.fabric8.servicecatalog.client.dsl.ClusterServiceClassResource;
import io.fabric8.servicecatalog.client.dsl.ClusterServicePlanResource;
import java.util.HashMap;
import java.util.List;

public class ClusterServiceClassOperationsImpl
extends ExtensibleResourceAdapter<ClusterServiceClass>
implements ClusterServiceClassResource {
    public ExtensibleResourceAdapter<ClusterServiceClass> newInstance() {
        return new ClusterServiceClassOperationsImpl();
    }

    @Override
    public ClusterServicePlanList listPlans() {
        ClusterServiceClass item = (ClusterServiceClass)this.get();
        return (ClusterServicePlanList)((FilterWatchListDeletable)((ServiceCatalogClient)this.client.adapt(ServiceCatalogClient.class)).clusterServicePlans().withField("spec.clusterServiceClassRef.name", item != null ? item.getMetadata().getName() : null)).list();
    }

    @Override
    public ClusterServicePlanResource usePlan(String externalName) {
        ClusterServiceClass item = (ClusterServiceClass)this.get();
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("spec.clusterServiceClassRef.name", item.getMetadata().getName());
        fields.put("spec.externalName", externalName);
        List list = ((ClusterServicePlanList)((FilterWatchListDeletable)((ServiceCatalogClient)this.client.adapt(ServiceCatalogClient.class)).clusterServicePlans().withFields(fields)).list()).getItems();
        if (list.size() != 1) {
            throw new IllegalArgumentException("No unique ClusterServicePlan with external name: " + externalName + " found for ClusterServiceBroker: " + item.getSpec().getClusterServiceBrokerName() + " and ClusterServiceClass: " + item.getSpec().getExternalName() + ".");
        }
        ClusterServicePlan plan = (ClusterServicePlan)list.get(0);
        return (ClusterServicePlanResource)((ServiceCatalogClient)this.client.adapt(ServiceCatalogClient.class)).clusterServicePlans().resource((Object)plan);
    }

    @Override
    public ServiceInstance instantiate(String instanceName, String plan) {
        ClusterServiceClass item = (ClusterServiceClass)this.get();
        return (ServiceInstance)((ServiceCatalogClient)this.client.adapt(ServiceCatalogClient.class)).serviceInstances().create((Object)((ServiceInstanceBuilder)((ServiceInstanceFluent.SpecNested)((ServiceInstanceFluent.SpecNested)((ServiceInstanceBuilder)((ServiceInstanceFluent.MetadataNested)new ServiceInstanceBuilder().withNewMetadata().withName(instanceName)).endMetadata()).withNewSpec().withClusterServiceClassExternalName(item.getMetadata().getName())).withClusterServicePlanExternalName(plan)).endSpec()).build());
    }
}

