/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.reactor;

import io.github.resilience4j.circuitbreaker.CallNotPermittedException;
import io.github.resilience4j.reactor.IllegalPublisherException;
import io.github.resilience4j.reactor.circuitbreaker.operator.CircuitBreakerOperator;
import io.github.resilience4j.reactor.retry.RetryOperator;
import io.github.resilience4j.reactor.timelimiter.TimeLimiterOperator;
import io.github.resilience4j.retry.MaxRetriesExceededException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactorOperatorFallbackDecorator<T>
implements UnaryOperator<Publisher<T>> {
    private final Map<Class<? extends Throwable>, Publisher<T>> FALLBACK_PUBLISHER_CACHE = new HashMap<Class<? extends Throwable>, Publisher<T>>();

    private ReactorOperatorFallbackDecorator(Class<? extends Throwable> throwableType, Publisher<T> fallback) {
        this.FALLBACK_PUBLISHER_CACHE.put(throwableType, fallback);
    }

    public ReactorOperatorFallbackDecorator<T> withFallback(Class<? extends Throwable> throwableType, Publisher<T> fallback) {
        this.FALLBACK_PUBLISHER_CACHE.put(throwableType, fallback);
        return this;
    }

    public static <T> ReactorOperatorFallbackDecorator<T> of(Class<? extends Throwable> throwableType, Publisher<T> fallback) {
        return new ReactorOperatorFallbackDecorator<T>(throwableType, fallback);
    }

    @Override
    public Publisher<T> apply(Publisher<T> publisher) {
        if (publisher instanceof Mono) {
            Mono upstream = (Mono)publisher;
            if (!this.FALLBACK_PUBLISHER_CACHE.isEmpty()) {
                for (Map.Entry classPublisherEntry : this.FALLBACK_PUBLISHER_CACHE.entrySet()) {
                    upstream = upstream.onErrorResume(classPublisherEntry.getKey(), throwable -> (Mono)classPublisherEntry.getValue());
                }
            }
            return upstream;
        }
        if (publisher instanceof Flux) {
            Flux upstream = (Flux)publisher;
            if (!this.FALLBACK_PUBLISHER_CACHE.isEmpty()) {
                for (Map.Entry classPublisherEntry : this.FALLBACK_PUBLISHER_CACHE.entrySet()) {
                    upstream = upstream.onErrorResume(classPublisherEntry.getKey(), throwable -> (Publisher)classPublisherEntry.getValue());
                }
            }
            return upstream;
        }
        throw new IllegalPublisherException(publisher);
    }

    public Function<Publisher<T>, Publisher<T>> decorate(UnaryOperator<Publisher<T>> operator) {
        return this.compose(operator);
    }

    public static <T> Function<Publisher<T>, Publisher<T>> decorateRetry(RetryOperator<T> retryOperator, Publisher<T> fallbackPublisher) {
        return ReactorOperatorFallbackDecorator.of(MaxRetriesExceededException.class, fallbackPublisher).decorate(retryOperator);
    }

    public static <T> Function<Publisher<T>, Publisher<T>> decorateCircuitBreaker(CircuitBreakerOperator<T> circuitBreakerOperator, Publisher<T> fallbackPublisher) {
        return ReactorOperatorFallbackDecorator.of(CallNotPermittedException.class, fallbackPublisher).decorate(circuitBreakerOperator);
    }

    public static <T> Function<Publisher<T>, Publisher<T>> decorateTimeLimiter(TimeLimiterOperator<T> timeLimiterOperator, Publisher<T> fallbackPublisher) {
        return ReactorOperatorFallbackDecorator.of(TimeoutException.class, fallbackPublisher).decorate(timeLimiterOperator);
    }
}

