/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.reactor.timelimiter;

import io.github.resilience4j.reactor.IllegalPublisherException;
import io.github.resilience4j.timelimiter.TimeLimiter;
import java.time.Duration;
import java.util.function.UnaryOperator;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class TimeLimiterOperator<T>
implements UnaryOperator<Publisher<T>> {
    private final TimeLimiter timeLimiter;

    private TimeLimiterOperator(TimeLimiter timeLimiter) {
        this.timeLimiter = timeLimiter;
    }

    public static <T> TimeLimiterOperator<T> of(TimeLimiter timeLimiter) {
        return new TimeLimiterOperator<T>(timeLimiter);
    }

    @Override
    public Publisher<T> apply(Publisher<T> publisher) {
        if (publisher instanceof Mono) {
            return this.withTimeout((Mono)publisher);
        }
        if (publisher instanceof Flux) {
            return this.withTimeout((Flux)publisher);
        }
        throw new IllegalPublisherException(publisher);
    }

    private Publisher<T> withTimeout(Mono<T> upstream) {
        return upstream.timeout(this.getTimeout()).doOnSuccess(t -> this.timeLimiter.onSuccess()).doOnError(arg_0 -> ((TimeLimiter)this.timeLimiter).onError(arg_0));
    }

    private Publisher<T> withTimeout(Flux<T> upstream) {
        return upstream.timeout(this.getTimeout()).doOnNext(t -> this.timeLimiter.onSuccess()).doOnComplete(() -> ((TimeLimiter)this.timeLimiter).onSuccess()).doOnError(arg_0 -> ((TimeLimiter)this.timeLimiter).onError(arg_0));
    }

    private Duration getTimeout() {
        return this.timeLimiter.getTimeLimiterConfig().getTimeoutDuration();
    }
}

