/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.autoconfigure;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.spring.autoconfigure.MeterRegistryConfigurer;
import io.micrometer.spring.autoconfigure.MeterRegistryCustomizer;
import io.micrometer.spring.autoconfigure.MetricsProperties;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;

class MeterRegistryPostProcessor
implements BeanPostProcessor {
    private final ObjectProvider<List<MeterBinder>> meterBinders;
    private final ObjectProvider<List<MeterFilter>> meterFilters;
    private final ObjectProvider<List<MeterRegistryCustomizer<?>>> meterRegistryCustomizers;
    private final ObjectProvider<MetricsProperties> metricsProperties;
    private volatile MeterRegistryConfigurer configurer;
    private volatile ApplicationContext applicationContext;

    MeterRegistryPostProcessor(ObjectProvider<List<MeterBinder>> meterBinders, ObjectProvider<List<MeterFilter>> meterFilters, ObjectProvider<List<MeterRegistryCustomizer<?>>> meterRegistryCustomizers, ObjectProvider<MetricsProperties> metricsProperties, ApplicationContext applicationContext) {
        this.meterBinders = meterBinders;
        this.meterFilters = meterFilters;
        this.meterRegistryCustomizers = meterRegistryCustomizers;
        this.metricsProperties = metricsProperties;
        this.applicationContext = applicationContext;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof MeterRegistry) {
            this.getConfigurer().configure((MeterRegistry)bean);
        }
        return bean;
    }

    private MeterRegistryConfigurer getConfigurer() {
        if (this.configurer == null) {
            boolean hasCompositeMeterRegistry = this.applicationContext.getBeanNamesForType(CompositeMeterRegistry.class, false, false).length != 0;
            this.configurer = new MeterRegistryConfigurer(this.getOrEmpty((List)this.meterBinders.getIfAvailable()), this.getOrEmpty((List)this.meterFilters.getIfAvailable()), this.getOrEmpty((List)this.meterRegistryCustomizers.getIfAvailable()), ((MetricsProperties)this.metricsProperties.getObject()).isUseGlobalRegistry(), hasCompositeMeterRegistry);
        }
        return this.configurer;
    }

    private <T> List<T> getOrEmpty(List<T> list) {
        return list != null ? list : Collections.emptyList();
    }
}

