/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.logging.otlp.internal.metrics;

import io.opentelemetry.exporter.logging.otlp.internal.metrics.OtlpStdoutMetricExporter;
import io.opentelemetry.exporter.logging.otlp.internal.writer.JsonWriter;
import io.opentelemetry.exporter.logging.otlp.internal.writer.LoggerJsonWriter;
import io.opentelemetry.exporter.logging.otlp.internal.writer.StreamJsonWriter;
import io.opentelemetry.sdk.metrics.export.AggregationTemporalitySelector;
import io.opentelemetry.sdk.metrics.export.DefaultAggregationSelector;
import java.io.OutputStream;
import java.util.Objects;
import java.util.logging.Logger;

public final class OtlpStdoutMetricExporterBuilder {
    private static final String TYPE = "metrics";
    private static final AggregationTemporalitySelector DEFAULT_AGGREGATION_TEMPORALITY_SELECTOR = AggregationTemporalitySelector.alwaysCumulative();
    private AggregationTemporalitySelector aggregationTemporalitySelector = DEFAULT_AGGREGATION_TEMPORALITY_SELECTOR;
    private DefaultAggregationSelector defaultAggregationSelector = DefaultAggregationSelector.getDefault();
    private final Logger logger;
    private JsonWriter jsonWriter;
    private boolean wrapperJsonObject = true;

    public OtlpStdoutMetricExporterBuilder(Logger logger) {
        this.logger = logger;
        this.jsonWriter = new LoggerJsonWriter(logger, TYPE);
    }

    public OtlpStdoutMetricExporterBuilder setWrapperJsonObject(boolean wrapperJsonObject) {
        this.wrapperJsonObject = wrapperJsonObject;
        return this;
    }

    public OtlpStdoutMetricExporterBuilder setOutput(OutputStream outputStream) {
        Objects.requireNonNull(outputStream, "outputStream");
        this.jsonWriter = new StreamJsonWriter(outputStream, TYPE);
        return this;
    }

    public OtlpStdoutMetricExporterBuilder setOutput(Logger logger) {
        Objects.requireNonNull(logger, "logger");
        this.jsonWriter = new LoggerJsonWriter(logger, TYPE);
        return this;
    }

    public OtlpStdoutMetricExporterBuilder setAggregationTemporalitySelector(AggregationTemporalitySelector aggregationTemporalitySelector) {
        Objects.requireNonNull(aggregationTemporalitySelector, "aggregationTemporalitySelector");
        this.aggregationTemporalitySelector = aggregationTemporalitySelector;
        return this;
    }

    public OtlpStdoutMetricExporterBuilder setDefaultAggregationSelector(DefaultAggregationSelector defaultAggregationSelector) {
        Objects.requireNonNull(defaultAggregationSelector, "defaultAggregationSelector");
        this.defaultAggregationSelector = defaultAggregationSelector;
        return this;
    }

    public OtlpStdoutMetricExporter build() {
        return new OtlpStdoutMetricExporter(this.logger, this.jsonWriter, this.wrapperJsonObject, this.aggregationTemporalitySelector, this.defaultAggregationSelector);
    }
}

