/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave.okhttp;

import com.github.kristofa.brave.Brave;
import com.github.kristofa.brave.ClientRequestAdapter;
import com.github.kristofa.brave.ClientRequestInterceptor;
import com.github.kristofa.brave.ClientResponseAdapter;
import com.github.kristofa.brave.ClientResponseInterceptor;
import com.github.kristofa.brave.http.DefaultSpanNameProvider;
import com.github.kristofa.brave.http.HttpClientRequest;
import com.github.kristofa.brave.http.HttpClientRequestAdapter;
import com.github.kristofa.brave.http.HttpClientResponseAdapter;
import com.github.kristofa.brave.http.HttpResponse;
import com.github.kristofa.brave.http.SpanNameProvider;
import com.github.kristofa.brave.internal.Util;
import com.github.kristofa.brave.okhttp.OkHttpRequest;
import com.github.kristofa.brave.okhttp.OkHttpResponse;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class BraveOkHttpRequestResponseInterceptor
implements Interceptor {
    private final ClientRequestInterceptor requestInterceptor;
    private final ClientResponseInterceptor responseInterceptor;
    private final SpanNameProvider spanNameProvider;

    public static BraveOkHttpRequestResponseInterceptor create(Brave brave) {
        return new Builder(brave).build();
    }

    public static Builder builder(Brave brave) {
        return new Builder(brave);
    }

    BraveOkHttpRequestResponseInterceptor(Builder b) {
        this.requestInterceptor = b.brave.clientRequestInterceptor();
        this.responseInterceptor = b.brave.clientResponseInterceptor();
        this.spanNameProvider = b.spanNameProvider;
    }

    @Deprecated
    public BraveOkHttpRequestResponseInterceptor(ClientRequestInterceptor requestInterceptor, ClientResponseInterceptor responseInterceptor, SpanNameProvider spanNameProvider) {
        this.spanNameProvider = spanNameProvider;
        this.requestInterceptor = requestInterceptor;
        this.responseInterceptor = responseInterceptor;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Request.Builder builder = request.newBuilder();
        OkHttpRequest okHttpRequest = new OkHttpRequest(builder, request);
        this.requestInterceptor.handle((ClientRequestAdapter)new HttpClientRequestAdapter((HttpClientRequest)okHttpRequest, this.spanNameProvider));
        Response response = chain.proceed(builder.build());
        this.responseInterceptor.handle((ClientResponseAdapter)new HttpClientResponseAdapter((HttpResponse)new OkHttpResponse(response)));
        return response;
    }

    public static final class Builder {
        final Brave brave;
        SpanNameProvider spanNameProvider = new DefaultSpanNameProvider();

        Builder(Brave brave) {
            this.brave = (Brave)Util.checkNotNull((Object)brave, (String)"brave", (Object[])new Object[0]);
        }

        public Builder spanNameProvider(SpanNameProvider spanNameProvider) {
            this.spanNameProvider = (SpanNameProvider)Util.checkNotNull((Object)spanNameProvider, (String)"spanNameProvider", (Object[])new Object[0]);
            return this;
        }

        public BraveOkHttpRequestResponseInterceptor build() {
            return new BraveOkHttpRequestResponseInterceptor(this);
        }
    }
}

