/*
 * Decompiled with CFR 0.152.
 */
package me.joshlarson.json;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import me.joshlarson.json.JSONObject;
import me.joshlarson.json.JSONOutputStream;

public class JSONArray
implements List<Object>,
Iterable<Object> {
    private final ArrayList<Object> array = new ArrayList();

    @Override
    public int size() {
        return this.array.size();
    }

    @Override
    public void clear() {
        this.array.clear();
    }

    @Override
    public Object remove(int index) {
        if (index < 0 || index >= this.array.size()) {
            throw new IndexOutOfBoundsException("Specified index " + index + " is out of range! [0, " + this.size() + ")");
        }
        return this.array.remove(index);
    }

    @Override
    public void add(int index, Object o) {
        if (o instanceof JSONObject || o instanceof JSONArray) {
            this.array.add(index, o);
        } else if (o instanceof Number || o instanceof Boolean) {
            this.array.add(index, o);
        } else if (o instanceof String) {
            this.array.add(index, o);
        } else if (o == null) {
            this.array.add(index, null);
        } else {
            throw new IllegalArgumentException("Object must be of type: JSONObject, JSONArray, Number, Boolean, String, or null!");
        }
    }

    @Override
    public boolean add(Object o) {
        if (o instanceof JSONObject) {
            this.add((JSONObject)o);
        } else if (o instanceof JSONArray) {
            this.add((JSONArray)o);
        } else if (o instanceof Number) {
            this.add((Number)o);
        } else if (o instanceof Boolean) {
            this.add((Boolean)o);
        } else if (o instanceof String) {
            this.add((String)o);
        } else if (o == null) {
            this.addNull();
        } else {
            throw new IllegalArgumentException("Object must be of type: JSONObject, JSONArray, Number, Boolean, String, or null!");
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Object> c) {
        this.ensureCapacity(this.size() + c.size());
        for (Object object : c) {
            this.add(object);
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends Object> c) {
        this.ensureCapacity(this.size() + c.size());
        int i = index;
        for (Object object : c) {
            this.add(i++, object);
        }
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.array.containsAll(c);
    }

    public void ensureCapacity(int minCapacity) {
        this.array.ensureCapacity(minCapacity);
    }

    @Override
    public int indexOf(Object o) {
        return this.array.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.array.isEmpty();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.array.lastIndexOf(o);
    }

    @Override
    public boolean remove(Object o) {
        return this.array.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.array.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.array.retainAll(c);
    }

    @Override
    public Object set(int index, Object element) {
        return this.array.set(index, element);
    }

    @Override
    public List<Object> subList(int fromIndex, int toIndex) {
        return this.array.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.array.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.array.toArray(a);
    }

    @Override
    public ListIterator<Object> listIterator() {
        return this.array.listIterator();
    }

    @Override
    public ListIterator<Object> listIterator(int index) {
        return this.array.listIterator(index);
    }

    public void add(JSONObject obj) {
        this.array.add(obj);
    }

    public void add(JSONArray array) {
        this.array.add(array);
    }

    public void add(Number n) {
        this.array.add(n);
    }

    public void add(Boolean b) {
        this.array.add(b);
    }

    public void add(String str) {
        this.array.add(str);
    }

    public void addNull() {
        this.array.add(null);
    }

    @Override
    public Object get(int index) {
        return this.array.get(index);
    }

    public JSONObject getObject(int index) {
        return (JSONObject)this.get(index);
    }

    public JSONArray getArray(int index) {
        return (JSONArray)this.get(index);
    }

    public int getInt(int index) {
        return ((Number)this.get(index)).intValue();
    }

    public long getLong(int index) {
        return ((Number)this.get(index)).longValue();
    }

    public float getFloat(int index) {
        return ((Number)this.get(index)).floatValue();
    }

    public double getDouble(int index) {
        return ((Number)this.get(index)).doubleValue();
    }

    public boolean getBoolean(int index) {
        return (Boolean)this.get(index);
    }

    public String getString(int index) {
        return (String)this.get(index);
    }

    @Override
    public boolean contains(Object o) {
        return this.array.contains(o);
    }

    @Override
    public Iterator<Object> iterator() {
        return this.array.iterator();
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (JSONOutputStream stream = new JSONOutputStream(baos);){
            stream.writeArray(this);
        }
        catch (IOException e) {
            return "Failed: " + e.getMessage();
        }
        return baos.toString();
    }
}

