/*
 * Decompiled with CFR 0.152.
 */
package me.joshlarson.json;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import me.joshlarson.json.JSONArray;
import me.joshlarson.json.JSONOutputStream;

public class JSONObject
implements Map<String, Object> {
    private final Map<String, Object> attributes = new LinkedHashMap<String, Object>();

    @Override
    public int size() {
        return this.attributes.size();
    }

    @Override
    public void clear() {
        this.attributes.clear();
    }

    public Object remove(String key) {
        if (key == null) {
            throw new NullPointerException("Key cannot be null!");
        }
        return this.attributes.remove(key);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.attributes.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.attributes.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.attributes.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.attributes.isEmpty();
    }

    @Override
    public Object put(String key, Object value) {
        if (value instanceof JSONObject || value instanceof JSONArray) {
            return this.attributes.put(key, value);
        }
        if (value instanceof Number || value instanceof Boolean) {
            return this.attributes.put(key, value);
        }
        if (value instanceof String) {
            return this.attributes.put(key, value);
        }
        if (value == null) {
            return this.attributes.put(key, null);
        }
        throw new IllegalArgumentException("Value must be of type: JSONObject, JSONArray, Number, Boolean, String, or null!");
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        for (Map.Entry<? extends String, ? extends Object> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public Object remove(Object key) {
        return this.attributes.remove(key);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.attributes.entrySet();
    }

    @Override
    public Set<String> keySet() {
        return this.attributes.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.attributes.values();
    }

    @Override
    public boolean equals(Object o) {
        return this.attributes.equals(o);
    }

    @Override
    public int hashCode() {
        return this.attributes.hashCode();
    }

    @Override
    public void put(String key, JSONObject value) {
        if (key == null) {
            throw new NullPointerException("Key cannot be null!");
        }
        this.attributes.put(key, value);
    }

    @Override
    public void put(String key, JSONArray value) {
        if (key == null) {
            throw new NullPointerException("Key cannot be null!");
        }
        this.attributes.put(key, value);
    }

    @Override
    public void put(String key, Number value) {
        if (key == null) {
            throw new NullPointerException("Key cannot be null!");
        }
        this.attributes.put(key, value);
    }

    @Override
    public void put(String key, Boolean value) {
        if (key == null) {
            throw new NullPointerException("Key cannot be null!");
        }
        this.attributes.put(key, value);
    }

    @Override
    public void put(String key, String value) {
        if (key == null) {
            throw new NullPointerException("Key cannot be null!");
        }
        this.attributes.put(key, value);
    }

    public void putNull(String key) {
        if (key == null) {
            throw new NullPointerException("Key cannot be null!");
        }
        this.attributes.put(key, null);
    }

    public Object get(String key) {
        if (key == null) {
            throw new NullPointerException("Key cannot be null!");
        }
        return this.attributes.get(key);
    }

    public JSONObject getObject(String key) {
        return (JSONObject)this.get(key);
    }

    public JSONArray getArray(String key) {
        return (JSONArray)this.get(key);
    }

    public int getInt(String key) {
        return ((Number)this.get(key)).intValue();
    }

    public long getLong(String key) {
        return ((Number)this.get(key)).longValue();
    }

    public float getFloat(String key) {
        return ((Number)this.get(key)).floatValue();
    }

    public double getDouble(String key) {
        return ((Number)this.get(key)).doubleValue();
    }

    public boolean getBoolean(String key) {
        return (Boolean)this.get(key);
    }

    public String getString(String key) {
        return (String)this.get(key);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (JSONOutputStream stream = new JSONOutputStream(baos);){
            stream.writeObject(this);
        }
        catch (IOException e) {
            return "Failed: " + e.getMessage();
        }
        return baos.toString();
    }
}

