/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.config;

import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.component.IdentifiableComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class IdentifiableBeanPostProcessor
implements BeanPostProcessor {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(IdentifiableBeanPostProcessor.class);

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        if (bean instanceof IdentifiableComponent) {
            IdentifiableComponent component = (IdentifiableComponent)bean;
            if (component.getId() == null) {
                component.setId(beanName);
            } else if (this.log.isDebugEnabled()) {
                if (component.getId().equals(beanName)) {
                    this.log.trace("The 'id' property is redundant for bean with 'id' attribute '{}'", (Object)beanName);
                } else {
                    this.log.trace("The 'id' property is not the same as the 'id' attribute for bean '{}'!='{}'", (Object)component.getId(), (Object)beanName);
                }
            }
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        return bean;
    }
}

