/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.config;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.ext.spring.resource.PreferFileSystemResourceLoader;
import net.shibboleth.ext.spring.resource.ResourceHelper;
import net.shibboleth.utilities.java.support.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.convert.converter.Converter;

public class StringToResourceConverter
implements Converter<String, Resource>,
ApplicationContextAware {
    @Nullable
    private ApplicationContext applicationContext;
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(StringToResourceConverter.class);

    public Resource convert(String source) {
        PreferFileSystemResourceLoader loader = this.applicationContext == null ? new PreferFileSystemResourceLoader() : this.applicationContext;
        Resource result = ResourceHelper.of(loader.getResource(source));
        if ((source.endsWith(" ") || this.log.isDebugEnabled()) && !result.exists()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Resource at '{}' does not exist", (Object)source);
            }
            if (source.endsWith(" ")) {
                this.log.warn("Missing path '{}' ends with a space, check for stray characters", (Object)source);
            }
        }
        return result;
    }

    public void setApplicationContext(ApplicationContext context) {
        this.applicationContext = context;
    }
}

