/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.factory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.ListFactoryBean;

public class CombiningListFactoryBean
extends ListFactoryBean {
    private List<?> firstList = Collections.emptyList();
    private List<?> secondList = Collections.emptyList();

    public void setSourceList(List<?> sourceList) {
        throw new BeanCreationException("Call setFirstList() amnd setSecondList");
    }

    public List<?> getFirstList() {
        return this.firstList;
    }

    public void setFirstList(@Nonnull List<?> list) {
        this.firstList = (List)Constraint.isNotNull(list, (String)"First list must be nonnull");
    }

    public List<?> getSecondList() {
        return this.secondList;
    }

    public void setSecondList(@Nonnull List<?> list) {
        this.secondList = (List)Constraint.isNotNull(list, (String)"Second list must be nonnull");
    }

    protected List<Object> createInstance() {
        ArrayList combined = new ArrayList(this.firstList.size() + this.secondList.size());
        combined.addAll(this.firstList);
        combined.addAll(this.secondList);
        super.setSourceList(combined);
        return super.createInstance();
    }
}

