/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.xml.DelegatingEntityResolver;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LocalOnlyResourceEntityResolver
extends DelegatingEntityResolver {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(LocalOnlyResourceEntityResolver.class);
    @Nonnull
    private final ResourceLoader resourceLoader;

    public LocalOnlyResourceEntityResolver(@Nonnull ResourceLoader loader) {
        super(loader.getClassLoader());
        this.resourceLoader = loader;
    }

    @Nullable
    public InputSource resolveEntity(@Nullable String publicId, @Nullable String systemId) throws SAXException, IOException {
        InputSource source = super.resolveEntity(publicId, systemId);
        if (source == null && systemId != null) {
            String resourcePath = null;
            try {
                String systemRootUrl;
                String decodedSystemId = URLDecoder.decode(systemId, StandardCharsets.UTF_8);
                assert (decodedSystemId != null);
                String givenUrl = new URL(decodedSystemId).toString();
                if (givenUrl.startsWith(systemRootUrl = new File("").toURI().toURL().toString())) {
                    resourcePath = givenUrl.substring(systemRootUrl.length());
                }
            }
            catch (Exception ex) {
                this.log.debug("Could not resolve XML entity [{}] against system root URL", (Object)systemId, (Object)ex);
                resourcePath = systemId;
            }
            if (resourcePath != null) {
                this.log.trace("Trying to locate XML entity [{}] as resource [{}]", (Object)systemId, (Object)resourcePath);
                Resource resource = this.resourceLoader.getResource(resourcePath);
                source = new InputSource(resource.getInputStream());
                source.setPublicId(publicId);
                source.setSystemId(systemId);
                this.log.debug("Found XML entity [{}]:", (Object)systemId, (Object)resource);
            } else if (systemId.endsWith(".dtd") || systemId.endsWith(".xsd")) {
                Object url = systemId;
                if (((String)url).startsWith("http:")) {
                    url = "https:" + ((String)url).substring(5);
                }
                this.log.warn("Blocking attempted remote resolution of [{}]", (Object)systemId);
                throw new IOException("Blocked atttempted remote resolution");
            }
        }
        return source;
    }
}

