package order.web.config;

import ma.glasnost.orika.MapperFacade;
import ma.glasnost.orika.MapperFactory;
import ma.glasnost.orika.impl.DefaultMapperFactory;
import ma.glasnost.orika.metadata.ClassMapBuilder;
import order.vo.*;
import order.vo.response.OrderItemPrice;
import order.vo.response.OrderItemStock;
import order.vo.response.OrderPrice;
import order.vo.response.OrderStock;
import order.web.vo.*;
import order.web.vo.response.WebOrderItemPrice;
import order.web.vo.response.WebOrderItemStock;
import order.web.vo.response.WebOrderPrice;
import order.web.vo.response.WebOrderStock;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.LinkedList;
import java.util.List;

/**
 * Created by xujingfeng on 2017/6/22.
 */
@Configuration
public class OrikaConfig {

    @Bean
    MapperFactory tempOrderMapperFactory() {
        MapperFactory mapperFactory = new DefaultMapperFactory.Builder().build();
        List<ClassMapBuilder> builders = new LinkedList<>();
        builders.add(mapperFactory.classMap(WebTempOrderVo.class, TempOrderVo.class));
        builders.add(mapperFactory.classMap(WebTempInvoiceVo.class, TempInvoiceVo.class));
        builders.add(mapperFactory.classMap(WebTempOrderAttrVo.class, OrderAttrVo.class));
        builders.add(mapperFactory.classMap(WebTempOrderCouponVo.class, OrderCouponVo.class));
        builders.add(mapperFactory.classMap(WebTempSubOrderVo.class, TempSubOrderVo.class));
        builders.add(mapperFactory.classMap(WebTempOrderItemVo.class, TempOrderItemVo.class));
        builders.add(mapperFactory.classMap(WebTempOrderGiftVo.class, TmpOrderGiftVo.class));
        builders.add(mapperFactory.classMap(WebOrderItemPrice.class, OrderItemPrice.class));
        builders.add(mapperFactory.classMap(WebOrderItemStock.class, OrderItemStock.class));
        builders.add(mapperFactory.classMap(WebOrderPrice.class, OrderPrice.class));
        builders.add(mapperFactory.classMap(WebOrderStock.class, OrderStock.class));


        for (ClassMapBuilder builder : builders) {
            builder.byDefault().register();
        }
        return mapperFactory;
    }

    @Bean
    MapperFacade tempOrderMapperFacade() {
        MapperFacade mapper = tempOrderMapperFactory().getMapperFacade();
        return mapper;
    }


}
