package order.web.controller;

import cart.api.OrderMainApi;
import cart.api.vo.TempOrderItemVo;
import cart.api.vo.TempOrderStoreVo;
import cart.api.vo.TempOrderVo;
import com.alibaba.fastjson.JSONObject;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import member.api.*;
import member.api.dto.core.CoreCompanyDto;
import member.api.dto.shop.MemberAddressDto;
import member.api.vo.MemberVo;
import order.web.service.MallBatchOrderService;
import order.web.vo.*;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import sinomall.global.common.response.BaseResponse;
import springfox.documentation.annotations.ApiIgnore;
import store.api.dto.modeldto.core.StoreDto;
import sysmg.api.SystemConfigApi;
import sysmg.dto.SystemConfigDto;
import sysmg.response.SystemConfigValueDto;
import utils.GlobalContants;
import utils.Lang;
import utils.file.FileUtils;
import utils.number.MoneyConvert;
import utils.pdf.PDFUtils;
import workflow.definition.WorkFlowCode;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * @author junyang.dong
 * @version v1.0
 * @date 2018/5/10
 * 商城直购批量下单
 */
@ApiIgnore
@RestController
@RequestMapping("mallBatchOrder")
public class MallBatchOrderController {
    Logger logger = LoggerFactory.getLogger(MallBatchOrderController.class);

    @Value("${templete.agreement.url}")
    private String tplpath;
    @Autowired
    private MallBatchOrderService mallBatchOrderService;
    @MotanReferer
    private MemberAddressApi memberAddressApi;
    @MotanReferer
    private CoreCompDepartUserApi coreCompDepartUserApi;
    @MotanReferer
    private CoreCompanyApi coreCompanyApi;
    @MotanReferer
    private SystemConfigApi systemConfigApi;
    @MotanReferer
    QueryInformationApi queryInformationApi;
    @MotanReferer
    MemberApi memberApi;
    @MotanReferer
    OrderMainApi orderMainApi;
    @Autowired
    RedissonClient redisClient;


    @Value("${mall.organizationCode}")
    private String organizationCode;

    public final static String VALUE_ADDED_TAX_SPECIAL_INVOICE = "增值税专用发票";
    public final static String VALUE_ADDED_TAX_NOMAL_INVOICE = "增值税普通发票";
    /**
     * 查询购物车商品
     * @param storeNo
     * @param goodsCode
     * @return
     */
    @RequestMapping(value = "/queryCartGoods")
    @ResponseBody
    public BaseResponse getCartGoods(String storeNo,String goodsCode,String addressId,HttpServletRequest request){
        String userId = (String) request.getSession().getAttribute(GlobalContants.SESSION_USER_ID);
        BaseResponse baseResponse = mallBatchOrderService.getCartGoods(userId,storeNo,goodsCode,addressId);
        return baseResponse;
    }

    /**
     * 获取所有店铺
     * @return
     */
    @RequestMapping(value = "/queryAllStore")
    @ResponseBody
    public BaseResponse getAllStore(){
        BaseResponse baseResponse = mallBatchOrderService.getAllStore();
        return baseResponse;
    }

    /**
     * 校验商品状态和库存
     * @param checkGoodsStockVo
     * @return
     */
    @RequestMapping(value = "/checkGoodsStatus")
    @ResponseBody
    public BaseResponse checkGoodsStatus(@RequestBody CheckGoodsStockVo checkGoodsStockVo,HttpServletRequest request){
        String userId = (String) request.getSession().getAttribute(GlobalContants.SESSION_USER_ID);
        BaseResponse baseResponse = mallBatchOrderService.checkGoodsStatus(checkGoodsStockVo,userId);
        return baseResponse;
    }

    /**
     * 保存临时订单
     * @param mallTempOrderVo
     * @return
     */
    @RequestMapping(value = "/saveTempOrder",method = RequestMethod.POST)
    @ResponseBody
    public BaseResponse saveTempOrder(@RequestBody MallTempOrderVo mallTempOrderVo,HttpServletRequest request){
        String memberId = (String) request.getSession().getAttribute(GlobalContants.SESSION_MEMBER_ID);
        if (!Lang.isEmpty(memberId)){
            mallTempOrderVo.setMemberId(memberId);
            MallTempOrderVo tempOrderVo = mallBatchOrderService.saveNewTempOrder(mallTempOrderVo);
            BaseResponse baseResponse = mallBatchOrderService.saveTempOrder(tempOrderVo);
            return baseResponse;
        }
        return new BaseResponse(false,"登录已失效，请重新登录");
    }

    /**
     * 临时订单查询
     * @param request
     * @return
     */
    @RequestMapping(value = "/queryTempOrder")
    @ResponseBody
    public BaseResponse queryTempOrder(HttpServletRequest request){
        String memberId = (String) request.getSession().getAttribute(GlobalContants.SESSION_MEMBER_ID);
//        String memberId="eeea060b-b662-47dc-aaf3-44639405850b";
        if (!Lang.isEmpty(memberId)){
            BaseResponse baseResponse = mallBatchOrderService.queryTempOrder(memberId);
            return baseResponse;
        }
        return new BaseResponse(true,"查询失败，登录已失效");
    }

    /**
     * 提交订单
     * @return
     */
    @RequestMapping(value = "/submitMallOrder")
    @ResponseBody
    public BaseResponse submitMallOrder(@RequestBody MallOrderSubmitVo mallOrderSubmitVo, HttpServletRequest request){
        String memberId = (String) request.getSession().getAttribute(GlobalContants.SESSION_MEMBER_ID);
        RLock lock = redisClient.getLock(memberId);
        lock.lock(5L, TimeUnit.MINUTES);
        logger.info(" isLocked{}",  lock.isLocked());
        try {
            if (!Lang.isEmpty(memberId)) {
                String orderTmpId = UUID.randomUUID().toString().replace("-", "");
                String resultSessionKey = "SUBMIT_RESULT_INFOES_" + orderTmpId;
                BaseResponse baseResponse = mallBatchOrderService.submitMallOrder(mallOrderSubmitVo, memberId, request);
                if ("error".equals(baseResponse.getResultCode())) {
                    if (!Lang.isEmpty(baseResponse.getResult())) {
                        Map<String, List<Map<String, String>>> errorInfoMap = (Map<String, List<Map<String, String>>>) baseResponse.getResult();
                        return new BaseResponse(false, "下单失败！可在批量订单列表中的“下单失败原因”列，查看具体失败原因", errorInfoMap);
                    }
                    return new BaseResponse(false, baseResponse.getResultMessage());
                } else {
                    Map map = new HashMap();
                    String orderNos = (String) baseResponse.getResult();
                    map.put("orderNos", orderNos);
                    request.getSession().setAttribute(resultSessionKey, map);
                    return new BaseResponse<>(true, "下单成功", orderTmpId);
                }

            }
        }catch (Exception e) {
            logger.error("[memberId:{}]下单失败....", memberId, e);
            return new BaseResponse(false,"下单失败，请联系管理员");

        }finally {
            lock.unlock();
        }
        return new BaseResponse(false,"登录失效，请重新登录");
    }

    /**
     * 下单校验
     * @param sumfreight
     * @param request
     * @return
     */
    @RequestMapping(value = "/checkMallOrder")
    @ResponseBody
    public BaseResponse checkMallOrder(String sumfreight, HttpServletRequest request){
        String memberId = (String) request.getSession().getAttribute(GlobalContants.SESSION_MEMBER_ID);
        String userId = (String) request.getSession().getAttribute(GlobalContants.SESSION_USER_ID);
        if(!Lang.isEmpty(memberId)){
            BaseResponse baseResponse = mallBatchOrderService.checkMallOrder(sumfreight,memberId,userId,request);
            return baseResponse;
        }
        return new BaseResponse(true,"登录失效，请重新登录");
    }

    /**
     * 获取运费
     * @return
     */
    @RequestMapping(value = "/getOrderFee")
    @ResponseBody
    public BaseResponse getOrderFee(HttpServletRequest request){
        String memberId = (String) request.getSession().getAttribute(GlobalContants.SESSION_MEMBER_ID);
        if (!Lang.isEmpty(memberId)){
            BaseResponse baseResponse = mallBatchOrderService.getOrderFee(memberId,request);
            return baseResponse;
        }
        return new BaseResponse(false,"登录已失效，请重新登录");
    }

    /**
     * 获取保存的订单信息
     * @return
     */
    @RequestMapping(value = "/queryTempOrderInfo")
    @ResponseBody
    public BaseResponse queryTempOrderInfo(HttpServletRequest request){
        String memberId = (String) request.getSession().getAttribute(GlobalContants.SESSION_MEMBER_ID);
        if(!Lang.isEmpty(memberId)){
            BaseResponse baseResponse = mallBatchOrderService.getTempOrderInfo(memberId);
            return baseResponse;
        }
        return new BaseResponse(false,"登录已失效，请重新登录");
    }

    /**
     * 批量下单Excel导入
     * @param req
     * @return
     */
    @RequestMapping(value = "/excel/receiverImport")
    @ResponseBody
    public BaseResponse importExcel(HttpServletRequest req) {
        BaseResponse baseResponse = mallBatchOrderService.batchImport(req);
        return baseResponse;
    }

    /**
     * 模板下载（导入结果下载）
     * @param req
     * @return
     */
    @RequestMapping(value = "downLoadExcel")
    public void downLoadExcel(HttpServletRequest req, HttpServletResponse res,String parame) {
        mallBatchOrderService.downLoadExcel(req,res,parame);
    }

    /**
     * 保存页面信息
     * @param mallTempOrderInfoVo
     * @param request
     * @return
     */
    @RequestMapping(value = "/saveTempOrderInfo")
    @ResponseBody
    public BaseResponse saveTempOrderInfo(@RequestBody MallTempOrderInfoVo mallTempOrderInfoVo,HttpServletRequest request){
        String memberId = (String) request.getSession().getAttribute(GlobalContants.SESSION_MEMBER_ID);
        if(!Lang.isEmpty(memberId)){
            BaseResponse baseResponse = mallBatchOrderService.saveTempOrderInfo(mallTempOrderInfoVo,memberId);
            return baseResponse;
        }
        return new BaseResponse(true,"登录已失效，请重新登录");
    }
    /**
     * 查询发票机构
     * @param companyId
     * @param companyLevel
     * @return
     */
    @RequestMapping(value = {"/companyInfo", "/companyInfo.json"})
    @ResponseBody
    public Map getCompanyInvoiceInfo(String companyId, String companyLevel) {
        if (Lang.isEmpty(companyId)) {
            return null;
        }
        //所选中的机构等级不能大于本级机构  否则给予错误提示
        Map map = new HashMap();
        CoreCompanyDto coreCompany = mallBatchOrderService.getCoreCompanyInfoById(companyId);
        map.put("company", coreCompany);
        return map;
    }

    /**
     * 删除临时订单
     * @param temOrderId
     * @return
     */
    @RequestMapping(value = "/deleteOrderInfo")
    @ResponseBody
    public BaseResponse deleteOrderInfo(@RequestBody List<String> temOrderId){
        BaseResponse baseResponse = mallBatchOrderService.deleteOrderInfo(temOrderId);
        return baseResponse;
    }

    /**
     * 修改临时订单
     * @param temOrderId
     * @return
     */
    @RequestMapping(value = "/updateOrderInfo")
    @ResponseBody
    public BaseResponse updateOrderInfo(String temOrderId){
        BaseResponse baseResponse = mallBatchOrderService.updateOrderInfo(temOrderId);
        return baseResponse;
    }

    /**
     * 修改会员地址编码（手动运维数据）
     */
    @RequestMapping(value="/changeMemberAddressNo")
    public void changeMemberAddressNo(){
         mallBatchOrderService.changeMemberAddressNo();
    }


    @RequestMapping("/getBatchOrderiaoXianCompany")
    public TiaoXianCompanyVo getBatchOrderiaoXianCompany(HttpServletRequest request, BigDecimal totalMoney) {
        String userId = (String) request.getSession().getAttribute(GlobalContants.SESSION_USER_ID);
        TiaoXianRequestVo tianXianRequestVo = new TiaoXianRequestVo();
        tianXianRequestVo.setUserId(userId);
        tianXianRequestVo.setUseCode(WorkFlowCode.ORDER_WORKFLOW_CODE.getCode());
        tianXianRequestVo.setTotalMoney(totalMoney);
        return mallBatchOrderService.getBatchOrderiaoXianCompany(tianXianRequestVo);
    }

    @RequestMapping(value = "/exportProtocol")
    public ResponseEntity<byte[]> exportProtocol(HttpServletRequest request,HttpServletResponse response){
        String memberId = (String) request.getSession().getAttribute(GlobalContants.SESSION_MEMBER_ID);
        String userId = (String) request.getSession().getAttribute(GlobalContants.SESSION_USER_ID);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
        List<ZipExportStructure> dataList = new ArrayList<ZipExportStructure>();
        byte[] zipData = null;
        MemberAddressDto address = null;
        boolean isProtocolStore = false;
        StringBuilder logsb = new StringBuilder();
        try{
            headers.setContentDispositionFormData("attachment",
                    FileUtils.transCharacter(request, "集团集采网上商城交易协议.zip"));
            for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                response.setHeader(entry.getKey(), entry.getValue().get(0));
            }
            MemberVo memberVo = mallBatchOrderService.findMemberVo(memberId, userId);
            CoreCompanyDto coreCompany = coreCompDepartUserApi.getBuyerCompany(memberVo.getUser().getId());
            List<TempOrderVo> mallTempOrderData = mallBatchOrderService.getMallTempOrderData(memberId);
            // 存放小订单信息的map集合
            List<Map<Object,Object>> orderMaps = new ArrayList<>();
            if (!Lang.isEmpty(mallTempOrderData)){
                // 取出订单信息封装map
                for (TempOrderVo order : mallTempOrderData) {
                    Map<Object,Object> orderDataMap = new HashMap<>();
                    List<TempOrderItemVo> orderItems = new ArrayList<>();
                    address = memberAddressApi.findById(order.getMemberAddrId());
                    BigDecimal sumOrderFee = BigDecimal.ZERO;
                    for (TempOrderStoreVo group : order.getStoreList()) {
                        for (TempOrderItemVo item : group.getOrderItems()) {
                            orderItems.add(item);
                            BigDecimal singleFee = orderMainApi.queryShippingFee(group.getStoreId(), group.getOrderItems(),
                                    order.getMemberAddrId());
                            if (!Lang.isEmpty(singleFee)){
                                sumOrderFee = sumOrderFee.add(singleFee);

                            }
                        }
                    }
                    List<TempOrderStoreVo> protocolStoreList = order.getStoreList().stream()
                            .filter(item -> StoreDto.STORE_TYPE_PROTOCOL.equals(item.getType()))
                            .collect(Collectors.toList());
                    isProtocolStore = protocolStoreList != null && protocolStoreList.size() > 0;
                    orderDataMap.put("storeName", order.getStoreList().get(0).getStoreName());
                    orderDataMap.put("orderItems", orderItems);
                    orderDataMap.put("order", order);
                    orderDataMap.put("chinaMoney", MoneyConvert.digitUppercase(order.getSumPrice().toString()));
                    orderDataMap.put("freight", sumOrderFee.doubleValue());
                    orderDataMap.put("coreCompany", coreCompany);
                    orderDataMap.put("address", address);
                    orderMaps.add(orderDataMap);
                }
            }
            // 批量生成PDF
            byte[] data = null;
            Integer number = 1;
            for (Map<Object, Object> orderMap : orderMaps) {
                CoreCompanyDto coreCompanyTwo = coreCompanyApi.getParentCompany(coreCompany.getId(), CoreCompanyDto.COMPANY_LEVEL_TWO);
                String agreeConfigStr = systemConfigApi.getConfigValue(organizationCode, SystemConfigDto.CONFIG_CODE_ORG_AGREE, SystemConfigValueDto.CONFIG_VALUE_TYPE_ORG_AGREE, true, true);
                Map<String, String> tplMap = JSONObject.parseObject(agreeConfigStr, Map.class);
                String tplName = tplMap.get(coreCompanyTwo.getCode());
                if (Lang.isEmpty(tplName)) {
                    tplName = "tpl.ftl";
                }
                if (isProtocolStore) {
                    tplName = "protocol.ftl";
                }
                TempOrderVo order = (TempOrderVo) orderMap.get("order");
                String fileName = order.getTmpOrderNo()+"_"+number+".pdf";
                data = PDFUtils.generateToServletOutputStream(tplpath, tplName, "", orderMap);
                ZipExportStructure ob = new ZipExportStructure();
                ob.setFileName(fileName);
                ob.setContent(data);
                dataList.add(ob);
                number++;
                logsb.append(order.getTmpOrderNo()+":"+"导出pdf成功"+"\r\n");
            }
            //单独生成一份log.txt用于说明本次保存
            logsb.append("finished"+"\r\n");
            ZipExportStructure ob = new ZipExportStructure();
            ob.setFileName("导出日志.log");
            ob.setContent(logsb.toString().getBytes());
            dataList.add(ob);
            // 集中批量打包
            zipData = mallBatchOrderService.Zip(dataList);
        }catch (Exception e){
            logger.error("......导出协议失败.....",e);
        }
        return new ResponseEntity<byte[]>(zipData, headers, HttpStatus.OK);
    }

    @RequestMapping(value = "/saveOrderAddress")
    @ResponseBody
    public Map saveOrderAddress(MemberAddressDto memberAddress, Map model, HttpServletRequest request, HttpServletResponse response){
        String memberId = (String) request.getSession().getAttribute(GlobalContants.SESSION_MEMBER_ID);
        HashMap<String, Object> rsMap = new HashMap<String, Object>();
        rsMap.put(GlobalContants.ResponseString.STATUS, GlobalContants.ResponseStatus.SUCCESS);
        rsMap.put(GlobalContants.ResponseString.ERROR_CODE, 0);
        try {
            MemberAddressDto res = memberAddressApi.saveOrderAddress(memberAddress,memberId);
            res.setMember(null);
            rsMap.put(GlobalContants.ResponseString.DATA, res);

        } catch (Exception e) {
            e.printStackTrace();
            rsMap.put(GlobalContants.ResponseString.STATUS, GlobalContants.ResponseStatus.ERROR);
            rsMap.put(GlobalContants.ResponseString.ERROR_CODE, 1);
            rsMap.put(GlobalContants.ResponseString.MESSAGE, e.getLocalizedMessage());
        }
        return rsMap;
    }
}
