package order.web.utils;

import org.apache.poi.hssf.usermodel.*;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.xmlbeans.impl.piccolo.io.FileFormatException;
import utils.Lang;

import java.io.*;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author 张代春
 * @date 2018/5/15
 */
public class ReadExcel {
    private static final String EXTENSION_XLS = "xls";
    private static final String EXTENSION_XLSX = "xlsx";

    /**
     * 读取exxcel 返回list 仅读取一个sheet
     * @param is
     * @param fileName
     * @return
     * @throws Exception
     */
    public static List readSingleExcel(InputStream is, String fileName) throws Exception {
        Workbook wb = null;
        List result = new ArrayList();
        try {
            wb = getWorkbook(is, fileName);
            handleOneSheetsExcel(wb, result);
        } catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return result;
    }


    private static Workbook getWorkbook(InputStream is, String fileName) throws IOException {
        Workbook workbook = null;
        try {
            if (fileName.endsWith(EXTENSION_XLS)) {
                workbook = new HSSFWorkbook(is);
            } else if (fileName.endsWith(EXTENSION_XLSX)) {
                workbook = new XSSFWorkbook(is);
            }

        } catch (FileNotFoundException e) {
            throw e;
        } catch (IOException e) {
            throw e;
        } finally {
            is.close();
        }

        return workbook;
    }
    /**
     * 处理多sheet excel
     *
     * @param wb
     * @param result
     */
    private static void handleOneSheetsExcel(Workbook wb, List result) {
        readRows(wb.getSheetAt(0), result);
    }

    /**
     * 读取一个 sheet
     * @param rows
     * @param rowsList
     */
    private static void readRows(Sheet rows, List rowsList) {
        boolean isEmptyRow = true;
        String cellStrVal;
        for (Row cells : rows) {
            isEmptyRow = true;
            List<String> cellList = new ArrayList<String>();
            for (Cell cell : cells) {
                cell.setCellType(Cell.CELL_TYPE_STRING);
                cellStrVal = cell.getStringCellValue();
                if(Lang.isEmpty(cellStrVal)){
                    cellStrVal="";
                }
                isEmptyRow = Lang.isEmpty(cellStrVal) && isEmptyRow;
                cellList.add(cellStrVal);
            }

            if(!isEmptyRow) {
                rowsList.add(cellList);
            }
        }
    }

    /**
     * 处理单sheet excel
     *
     * @param wb
     * @param result
     */
    private static void handleSingleSheetExcel(Workbook wb, List result) {
        readRows(wb.getSheetAt(0), result);
    }

    /**
     * 设置单元格宽度
     *
     * @param sheet
     */
    public static void setContentColumnWidth(HSSFSheet sheet, List<Map<String,Integer>> mapList) {
        for(Map<String,Integer> map:mapList) {
            sheet.setColumnWidth(map.get("index"), map.get("size"));//一般从0开始
        }

    }

    /**
     * 设置单元格样式
     *
     * @param wb
     * @return
     */
    public static HSSFCellStyle setContentCellStyle(HSSFWorkbook wb) {
        HSSFCellStyle cellStyle = wb.createCellStyle();
        HSSFFont font = wb.createFont();
        font.setFontName("黑体");
        font.setFontHeightInPoints((short) 10);//设置字体大小
//        font.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);//粗体显示
        cellStyle.setFont(font);
        cellStyle.setBorderBottom(HSSFCellStyle.BORDER_THIN);
        cellStyle.setBorderLeft(HSSFCellStyle.BORDER_THIN);
        cellStyle.setBorderRight(HSSFCellStyle.BORDER_THIN);
        cellStyle.setBorderTop(HSSFCellStyle.BORDER_THIN);
        cellStyle.setAlignment(HSSFCellStyle.ALIGN_CENTER);
        return cellStyle;
    }

    /**
     * 创建表头
     *
     * @param row
     * @param cellStyle
     * @param cell
     */
    public static void createCellHead(HSSFRow row, HSSFCellStyle cellStyle, HSSFCell cell, List<Map<String,String>> mapList) {
        cell.setCellStyle(cellStyle);
        for(Map<String,String> map:mapList ) {
            cell.setCellValue(map.get("name"));
            String  indexStr=(String)map.get("index");
            Integer indexInt=Integer.parseInt(indexStr);
            cell = row.createCell(indexInt);
        }
    }

    /**
     * 设置单元格内容
     *
     * @param value
     * @return
     */
    public static String setContentCellValue(String value) {
        if (Lang.isEmpty(value)) {
            return "";
        } else {
            return value;
        }
    }


    /**
     * 文件检查
     *
     * @param filePath
     * @throws FileNotFoundException
     * @throws FileFormatException
     */
    private void preReadCheck(String filePath)
            throws FileNotFoundException, FileFormatException {
        // 常规检查
        File file = new File(filePath);
        if (!file.exists()) {
            throw new FileNotFoundException("传入的文件不存在：" + filePath);
        }

        if (!(filePath.endsWith(EXTENSION_XLS)
                || filePath.endsWith(EXTENSION_XLSX))) {
            throw new FileFormatException("传入的文件不是excel");
        }
    }

}
