package order.web.vo;

import lombok.Data;
import utils.excel.excelcreate.annotation.ColumnName;
import utils.excel.excelcreate.annotation.Excel;
import java.io.Serializable;

/**
 * @author 张代春
 * @date 2018/4/8
 */
@Data
@Excel(sheetNames = {"sheet one"})
public class ExcelImportDataVo implements Serializable{
    /**
     * 店铺名称
     */
    @ColumnName(column = "店铺名称")
    private String storeName;
    /**
     * 商品Sku
     */
    @ColumnName(column = "商品编码")
    private String sku;
    /**
     * 商品数量
     */
    @ColumnName(column = "数量")
    private Integer num;

    /**
     * 收件人地址编码
     */
    @ColumnName(column = "商品收货地址编号")
    private String memberAddressCode;

    /**
     * 发票类型 1.增值税专用发票 2.增值税普通发票
     */
    @ColumnName(column = "发票类型")
    private String invoiceType;

    /**
     * 发票抬头
     */
    @ColumnName(column = "发票抬头")
    private String invoiceTitle;

    /**
     * 纳税人识别号
     */
    @ColumnName(column = "纳税人识别号")
    private String taxIdentification;

    /**
     * 发票收件地址码
     */
    @ColumnName(column = "发票收货地址编号")
    private String invoiceAddressCode;

    /**
     * 导入结果
     */
    @ColumnName(column = "导入结果")
    private String importResult;

    /**
     * 收货地址Id
     */
    private String memberAddressId;
    /**
     * 发票收货地址Id
     */
    private String invoiceAddressId;
    /**
     * 收货全地址
     */
    private String memberAddress;
    /**
     * 发票收货全地址
     */
    private String invoiceAddress;
    /**
     * 机构id
     */
    private String companyId;
    /**
     * 数据标记位
     */
    private String dataFlage;
    /**
     * 省地址编码
     */
    private String memberProviceCode;
    /**
     * 市地址编码
     */
    private String memberCityCode;
    /**
     * 县地址编码
     */
    private String memberCountryCode;
    /**
     * 区地址编码
     */
    private String memberTownCode;

}
