package order.web.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 创建订单请求VO
 *
 * @author Liang Wenxu
 * @since 2018-01-18
 */
@ApiModel(value = "TempOrderCreateRequest",
        description = "临时订单创建请求实体"
)
@Data
public class TempOrderCreateWebRequest implements Serializable {

    /**
     * 渠道代码
     */
    @ApiModelProperty(value = "渠道代码"
            , required = true
            , example = "jicai"
    )
    private String organizationCode;

    /**
     * 最末级地区编码
     */
    @ApiModelProperty(value = "最末级地区编码"
            , required = true
            , example = "440103"
    )
    private String areaCode;

    /**
     * 浏览器userAgent原文
     * <p>可通过request.getHeader("USER-AGENT").toLowerCase();获取</p>
     */
    @ApiModelProperty(value = "浏览器userAgent原文"
            , notes = "可通过以下方法获取tempOrderCreateRequest.userAgent = request.getHeader(\"USER-AGENT\").toLowerCase();web-api调用时不传此参数"
            , example = ""
    )
    private String userAgent;

    /**
     * 校验库存标志
     */
    @ApiModelProperty(value = "检验库存标志"
            , example = "true"
    )
    private Boolean checkStock;

    /**
     * 从购物车生成订单，提供多个购物车商品id
     */
    @ApiModelProperty(value = "从购物车生成订单，需提供多个购物车商品id列表"
            , example = "[\"5a319573-127f-4747-a2da-3414b1c0424e\",\"91e0dae9-29b1-45ef-ad18-d66a14fba754\",\"ba4ee5c1-65b2-4ecd-84a9-beb3640e05be\",\"1b8d78e2-6dc5-4640-9f03-3c84276e6ece\",\"32602db4-e893-441a-bc4d-a97570c040fd\",\"18f02106-8639-4193-943a-0accc2a269ad\"]"
    )
    private List<String> cartItemIds;

    /**
     * 通过产品创建订单
     */
    @ApiModelProperty(value = "通过产品直接生成订单，提供产品信息列表")
    private List<TempOrderProduct> products;

    private String requestId;
}
