package order.web.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 临时订单包含商品
 * @author Liang Wenxu
 * @since 2018-01-18
 */
@ApiModel(value="TempOrderProduct",
        description="临时订单创建请求实体"
)
@Data
public class TempOrderProduct implements Serializable {
    /**
     * 产品ID
     */
    @ApiModelProperty(value = "产品ID", required = true)
    private String productId;

    /**
     * 产品规格ID
     */
    @ApiModelProperty(value = "产品规格ID", required = true)
    private String productFashionId;

    /**
     * GoodsId
     */
    @ApiModelProperty(value = "兼容旧数据，如果Fashion没有关联的Goods，就要多传此参数", required = false)
    private String goodsId;

    /**
     * 购买数量
     */
    @ApiModelProperty(value = "购买数量", required = true)
    private Integer counts;

    /**
     * 产品类型，见GlobalContants.PRODUCT_TYPE_开头常量
     */
    @ApiModelProperty(value = "产品类型"
            , notes = "取值说明：1 -- 商品|2 -- 配件|3 -- 赠品"
            , allowableValues = "1,2,3"
            , required = true)
    private String productType;

    /**
     * 商品类型，{@link order.Contants#GOODS_TYPE_ENTITY}|{@link order.Contants#GOODS_TYPE_VIRTUAL}
     */
    @ApiModelProperty(value = "商品类型",
            notes = "取值说明：1 -- 实物商品，2 -- 虚拟商品",
            allowableValues = "1,2",
            required = true)
    private String goodsType;

    /**
     * 配件列表（配件也是商品）
     */
    List<TempOrderProduct> accessories;
}
