package order.web.vo;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 *
 * @author Dy
 * @date 2017-08-14
 */
@Data
public class WebTempInvoiceVo implements Serializable {

    /**
     * 增值税普通发票
     * 与membetInvoiceApi对应，01位普通，02位固有增值税发票信息
     */
    public static final String INVOICE_TYPE_COMMON = "007";
    /**
     * 增值税专用发票
     */
    public static final String INVOICE_TYPE_SPECIAL = "004";
    private static final long serialVersionUID = -5676889307518873747L;

    /**
     * 发票类型 007 个人 004 公司
     */
    private String invoiceType;

    /**
     * 公司ID
     */
    private String companyId;

    /**
     * 发票抬头
     */
    private String invoiceName;

    /**
     * 纳税人识别号
     */
    private String invoiceCode;

    /**
     * 发票商品行信息
     */
    private List<WebTempInvoiceItemVo> tempInvoiceItemVos;

    /**
     * 发票地址，每个发票有且仅有一个收货地址
     */
    private WebTempInvoiceAddrVo tempInvoiceAddrVo;
}
