package order.web.vo;

import com.alibaba.fastjson.annotation.JSONField;
import io.swagger.annotations.ApiModel;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 用于Web-Api的临时订单对象
 * @author Liang Wenxu
 * @since 2018/7/24
 */
@Data
@ApiModel(value = "临时订单")
public class WebTempOrderVo implements Serializable {
    /**
     * 临时订单号
     */
    private String tmpOrderNo;

    /**
     * 支付方式代码
     */
    private String payMethodCode;

    /**
     * 用户id
     */
    private String userId;

    /**
     * 会员id
     */
    private String memberId;

    /**
     * 父订单的单号
     */
    private String pOrderNo;

    /**
     * 创建时间
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    /**
     * 订单总价（实际应付总价，不含运费）
     */
    private BigDecimal sumPrice;

    /**
     * 订单总市场价
     */
    private BigDecimal sumMarketPrice;

    /**
     * 订单总成本价
     */
    private BigDecimal sumCostPrice;

    /**
     * 订单总原始销售价
     */
    private BigDecimal sumOrginalPrice;

    /**
     * 订单应收总价（含运费）
     */
    private BigDecimal needPayPrice;

    /**
     * 订单总运费
     */
    private BigDecimal sumShippingFee;

    private Boolean isFreeShippingFee = false;

    /**
     * 临时订单商品
     * <p>当该临时订单是父订单时将包括所有子订单的商品</p>
     */
    private List<WebTempOrderItemVo> orderItems;

    /**
     * 子订单
     * <p>当该临时订单是父订单时此字段有值</p>
     */
    private List<WebTempSubOrderVo> subOrders;

    /**
     * 订单礼品
     */
    private List<WebTempOrderGiftVo> tmpOrderGifts;

    /**
     * 订单扩展属性
     */
    private List<WebTempOrderAttrVo> orderAttrs;

    /**
     * 订单使用的优惠券
     */
    private List<WebTempOrderCouponVo> orderCouponVos;

    /**
     * 判断是否使用积分兑换 1是  0否
     */
    private String useScore;

    /**
     * 订单用途代码
     */
    private String usageCode;

    /**
     * 下单地区
     */
    private String areaCode;

    /**
     * 一个临时订单对应多个发票
     */
    private List<WebTempInvoiceVo> tempInvoiceVos;

    /**
     * 积分抵扣金额
     */
    private BigDecimal socrePrice;

    /**
     * 来源渠道代码
     */
    private String organizationCode;

    /**
     * 来源渠道表id
     */
    private String realOrganizationId;

    /**
     * 购买类型 ipad,mobile,pc
     */

    private String buyType;

    /**
     * 用来记录网页头信息
     */

    private String headMessage;

    /**
     * 浏览器类型
     */

    private String browserType;
    /**
     * 平台类型
     */

    private String platformType;

    /**
     * 请求ID
     */
    private String requestId;
    /**
     * memberAddressId
     */
    private String memberAddrId;

    private String parentOrderId;

    /**
     * 充值中心订单充值类型代码
     */
    private String rechargeTypeCode;

    /**
     * 积分兑换现金比值
     */
    private BigDecimal scoreExchangeMoneyRatio;

    /**
     * 订单积分抵扣金额限比
     */
    private BigDecimal orderUseScoreRatio;

    /**
     * 订单类型枚举
     */
    private String orderType;

    private String rechargePhone;

    public static final String IPAD = "ipad";
    public static final String MOBILE = "mobile";
    public static final String PC = "pc";

    /**
     * 返回总商品数量(一个商品购买多件仍视为一个商品)
     *
     * @return int 商品数量合计
     */
    public int getSumGoodsCount() {
        return this.orderItems.size();
    }

    /**
     * 返回购买商品件数合计（计算各商品的购买件数）
     *
     * @return int 商品数量合计
     */
    public int getSumGoodsBuyCount() {
        int sumGoodsCount = 0;
        for(WebTempOrderItemVo oi : this.orderItems) {
            sumGoodsCount += oi.getCount();
        }

        return sumGoodsCount;
    }
}
