package order.web.vo.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 临时订单价格查询结果
 * @author Liang Wenxu
 * @since 2018/7/24
 */
@Data
@ApiModel(value = "WebOrderPrice", description = "订单价格实体")
public class WebOrderPrice implements Serializable {
    /**
     * 订单号
     */
    @ApiModelProperty("订单号")
    private String orderNo;

    /**
     * 原始售价
     */
    @ApiModelProperty("原始售价")
    private BigDecimal orginalSumPrice;

    /**
     * 商品销售总价（不含运费）
     */
    @ApiModelProperty("总销售价格（含运费）")
    private BigDecimal salesPrice;

    /**
     * 订单总价（含运费）
     */
    @ApiModelProperty("总销售价格（不含运费）")
    private BigDecimal orderPrice;


    /**
     * 总运费
     */
    @ApiModelProperty("总运费，所有子单运费累计")
    private BigDecimal freight;

    /**
     * 总成本价
     */
    @ApiModelProperty("总成本价")
    private BigDecimal costPrice;

    /**
     * 总市场价
     */
    @ApiModelProperty("总市场价")
    private BigDecimal marketPrice;

    /**
     * 子订单的金额
     */
    List<WebOrderPrice> subOrderPrices;

    /**
     * 订单商品的价格
     */
    List<WebOrderItemPrice> orderItemPrices;
}
