package order.web.vo.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author Liang Wenxu
 * @since 2018/7/24
 */
@Data
@ApiModel(value = "WebOrderStock", description = "订单库存实体")
public class WebOrderStock implements Serializable {
    /**
     * 是否包括了无货商品
     */
    @ApiModelProperty(value = "是否无货商品", allowableValues = "1,0")
    private Boolean hasNoStock;

    /**
     * 各商品的详细库存情况
     */
    @ApiModelProperty(value = "各商品的详细库存情况")
    private List<WebOrderItemStock> itemStocks;

    /**
     * 子订单的库存状态
     */
    @ApiModelProperty(value = "子订单的库存状态")
    private List<WebOrderStock> subOrderStock;
}
