/*
 * Decompiled with CFR 0.152.
 */
package order.web.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import member.api.CoreUserApi;
import member.api.LoginApi;
import member.api.vo.MemberVo;
import okhttp3.FormBody;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import order.web.service.OrderWebService;
import order.web.vo.TempOrderCreateWebRequest;
import order.web.vo.WebTempOrderVo;
import order.web.vo.response.WebOrderPrice;
import order.web.vo.response.WebOrderStock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import sinomall.global.dto.WebResponse;
import utils.Lang;
import utils.security.MD5Utils;

@Api(value="mallorder", description="\u8ba2\u5355\u76f8\u5173API", tags={"OrderService"})
@RestController
@RequestMapping(value={"api/mallorder"})
public class MallOrderWebApiController {
    private static final Logger log = LoggerFactory.getLogger(MallOrderWebApiController.class);
    @Autowired
    OrderWebService orderWebService;
    @MotanReferer
    CoreUserApi coreUserApi;
    @MotanReferer
    LoginApi loginApi;
    @Autowired
    RedisTemplate redisTemplate;
    final String templateOrderKey = "order:temporder:key:";

    @ApiOperation(value="\u521b\u5efa\u4e34\u65f6\u8ba2\u5355", httpMethod="POST", notes="\u8be5API\u9700\u7528\u6237\u767b\u5f55\u540e\u624d\u53ef\u4f7f\u7528\uff0c\u63a5\u53e3\u652f\u6301\u3010\u4ece\u6307\u5b9a\u5546\u54c1\u3011\u6216\u3010\u6307\u5b9a\u8d2d\u7269\u8f66\u9879\u76ee\u3011\u521b\u5efa\u4e34\u65f6\u8ba2\u5355\uff0c\u4ece\u6307\u5b9a\u5546\u54c1\u521b\u5efa\u65f6\uff0cproducts\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u4ece\u8d2d\u7269\u8f66\u521b\u5efa\u65f6cartItemIds\u4e0d\u4e3a\u7a7a<p><b>\u8fd4\u56de\u4ee3\u7801\u8bf4\u660e\uff1a</b><br/>0001: \u672a\u63d0\u4ea4\u4efb\u4f55\u5546\u54c1<br/>0002: \u83b7\u53d6\u767b\u5f55\u7528\u6237\u5931\u8d25<br/>0003: \u6307\u5b9a\u7684\u4e34\u65f6\u8ba2\u5355\u83b7\u53d6\u5931\u8d25<br/>1001: \u672a\u63d0\u4f9b\u5546\u54c1\u6570\u636e<br/>1999: \u672a\u77e5\u53c2\u6570\u5f02\u5e38<br/>2001: \u8ba2\u5355\u4e2d\u5305\u542b\u4e86\u65e0\u8d27\u5546\u54c1<br/>2002: \u4e0b\u5355\u5730\u533aareaCode\u4e0d\u5408\u6cd5<br/>9999: \u672a\u5b9a\u4e49\u5f02\u5e38<br/></p>")
    @RequestMapping(value={"/temporder"}, method={RequestMethod.POST})
    public WebResponse<WebTempOrderVo> tempOrder(@org.springframework.web.bind.annotation.RequestBody TempOrderCreateWebRequest tempOrderCreateRequest, HttpServletRequest request) {
        WebResponse response;
        if ((tempOrderCreateRequest.getCartItemIds() == null || Lang.isEmpty((Object)tempOrderCreateRequest.getCartItemIds())) && (tempOrderCreateRequest.getProducts() == null || Lang.isEmpty((Object)tempOrderCreateRequest.getProducts()))) {
            response = WebResponse.ERROR((String)"0001", (String)"Required Paramter cartItemIds Is Empty!");
        } else {
            String userAgent = request.getHeader("USER-AGENT").toLowerCase();
            MemberVo memberVo = this.orderWebService.findMemberVo(request);
            if (memberVo != null) {
                BoundValueOperations tempOrderLock = this.redisTemplate.boundValueOps((Object)("order:temporder:key:" + memberVo.getMember().getId() + ":" + tempOrderCreateRequest.getRequestId()));
                if (tempOrderLock.setIfAbsent((Object)true).booleanValue()) {
                    tempOrderCreateRequest.setUserAgent(userAgent);
                    response = this.orderWebService.createTempOrder(tempOrderCreateRequest, memberVo, request.getSession());
                } else {
                    response = WebResponse.ERROR((String)"0005", (String)"request repeat");
                }
            } else {
                response = WebResponse.ERROR((String)"0002", (String)"Member Not Found!");
            }
        }
        return response;
    }

    @ApiOperation(value="\u4e34\u65f6\u8ba2\u5355\u8be6\u60c5\u83b7\u53d6\u63a5\u53e3", httpMethod="GET", notes="\u901a\u8fc7\u6b64\u63a5\u53e3\u83b7\u53d6\u4e34\u65f6\u8ba2\u5355\u7684\u4fe1\u606f<p><b>\u8fd4\u56de\u4ee3\u7801\u8bf4\u660e\uff1a</b><br/>0001: \u4e34\u65f6\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728<br/></p>")
    @ApiImplicitParams(value={@ApiImplicitParam(value="\u4e34\u65f6\u8ba2\u5355\u53f7", name="orderNo", paramType="path")})
    @RequestMapping(value={"/temporder/{orderNo}"}, method={RequestMethod.GET})
    public WebResponse<WebTempOrderVo> getTempOrder(@PathVariable(value="orderNo") String tempOrderNo, HttpServletRequest request) {
        WebResponse response = null;
        WebTempOrderVo tempOrderVo = this.orderWebService.getTempOrder(tempOrderNo, request.getSession());
        response = tempOrderVo != null ? WebResponse.SUCCESS((Object)tempOrderVo) : WebResponse.ERROR((String)"0001", (String)"\u8be5\u8ba2\u5355\u4e0d\u5b58\u5728");
        return response;
    }

    @ApiOperation(value="\u4e34\u65f6\u8ba2\u5355\u5e93\u5b58\u83b7\u53d6\u63a5\u53e3", httpMethod="GET", notes="\u901a\u8fc7\u6b64\u63a5\u53e3\u83b7\u53d6\u6700\u65b0\u7684\u5e93\u5b58\u72b6\u6001<p><b>\u8fd4\u56de\u4ee3\u7801\u8bf4\u660e\uff1a</b><br/>0001: \u4e34\u65f6\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728<br/>0002: areaCode\u672a\u6307\u5b9a<br/>0003: \u6307\u5b9a\u7684\u4e34\u65f6\u8ba2\u5355\u83b7\u53d6\u5931\u8d25<br/>1001: areaCode\u4ee3\u7801\u4e0d\u5408\u6cd5<br/></p>")
    @ApiImplicitParams(value={@ApiImplicitParam(value="\u4e34\u65f6\u8ba2\u5355\u53f7", name="orderNo", paramType="path"), @ApiImplicitParam(value="\u6700\u672b\u7ea7\u5730\u533a\u7f16\u7801", name="areaCode", paramType="path")})
    @RequestMapping(value={"/temporder/stock/{orderNo}/{areaCode}"}, method={RequestMethod.GET})
    public WebResponse<WebOrderStock> temporderStock(@PathVariable(value="orderNo") String tempOrderNo, @PathVariable(value="areaCode") String areaCode, HttpServletRequest request) {
        WebResponse response = new WebResponse();
        if (!Lang.isEmpty((Object)areaCode)) {
            if (this.orderWebService.tmpOrderIdExists(tempOrderNo, request.getSession()).booleanValue()) {
                WebTempOrderVo tempOrderVo = this.orderWebService.getTempOrder(tempOrderNo, request.getSession());
                if (tempOrderVo != null) {
                    tempOrderVo.setAreaCode(areaCode);
                    WebResponse orderStockResp = this.orderWebService.getOrderStock(tempOrderVo);
                    response = orderStockResp.getSuccess().booleanValue() ? WebResponse.SUCCESS((Object)orderStockResp.getData()) : WebResponse.ERROR((String)orderStockResp.getErrorCode(), (String)orderStockResp.getMessage());
                } else {
                    response = WebResponse.ERROR((String)"0003", (String)"\u6307\u5b9a\u7684\u8ba2\u5355\u4e0d\u5b58\u5728");
                }
            } else {
                response = WebResponse.ERROR((String)"0001", (String)("\u6ca1\u6709\u627e\u5230\u8ba2\u5355\u53f7" + tempOrderNo + "\u5bf9\u5e94\u7684\u4e34\u65f6\u8ba2\u5355"));
            }
        } else {
            response = WebResponse.ERROR((String)"0002", (String)"\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570areaCode");
        }
        return response;
    }

    @ApiOperation(value="\u91cd\u65b0\u83b7\u53d6\u4e34\u65f6\u8ba2\u5355\u7684\u4ef7\u683c", httpMethod="GET", notes="\u901a\u8fc7\u6b64\u63a5\u53e3\u83b7\u53d6\u6700\u65b0\u7684\u5e93\u5b58\u72b6\u6001<p><b>\u8fd4\u56de\u4ee3\u7801\u8bf4\u660e\uff1a</b><br/>0001: \u4e34\u65f6\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728<br/>0002: areaCode\u672a\u6307\u5b9a<br/>0003: \u6307\u5b9a\u7684\u4e34\u65f6\u8ba2\u5355\u83b7\u53d6\u5931\u8d25<br/>1001: areaCode\u4ee3\u7801\u4e0d\u5408\u6cd5<br/></p>")
    @ApiImplicitParams(value={@ApiImplicitParam(value="\u4e34\u65f6\u8ba2\u5355\u53f7", name="orderNo", paramType="path"), @ApiImplicitParam(value="\u6700\u672b\u7ea7\u5730\u533a\u7f16\u7801", name="areaCode", paramType="path")})
    @RequestMapping(value={"/temporder/price/{orderNo}/{areaCode}"}, method={RequestMethod.GET})
    public WebResponse<WebOrderPrice> tempOrderPrice(@PathVariable(value="orderNo") String tempOrderNo, @PathVariable(value="areaCode") String areaCode, HttpServletRequest request) {
        WebResponse response = new WebResponse();
        if (!Lang.isEmpty((Object)areaCode)) {
            if (this.orderWebService.tmpOrderIdExists(tempOrderNo, request.getSession()).booleanValue()) {
                WebTempOrderVo tempOrderVo = this.orderWebService.getTempOrder(tempOrderNo, request.getSession());
                if (tempOrderVo != null) {
                    tempOrderVo.setAreaCode(areaCode);
                    response = this.orderWebService.getOrderPrice(tempOrderVo);
                } else {
                    response = WebResponse.ERROR((String)"0003", (String)"\u6307\u5b9a\u7684\u8ba2\u5355\u4e0d\u5b58\u5728");
                }
            } else {
                response = WebResponse.ERROR((String)"0001", (String)("\u6ca1\u6709\u627e\u5230\u8ba2\u5355\u53f7" + tempOrderNo + "\u5bf9\u5e94\u7684\u4e34\u65f6\u8ba2\u5355"));
            }
        } else {
            response = WebResponse.ERROR((String)"0002", (String)"\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570areaCode");
        }
        return response;
    }

    @ApiOperation(value="\u6d4b\u8bd5\u767b\u9646\u7528\u63a5\u53e3\uff0c\u751f\u4ea7\u73af\u5883\u5173\u95ed\uff01")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userName", value="\u7528\u6237\u90ae\u7bb1", required=true, dataType="string", paramType="query", defaultValue="feijin@ec.cntaiping.com"), @ApiImplicitParam(name="pwd", value="\u5bc6\u7801", required=true, dataType="string", paramType="query", defaultValue="qwer1234"), @ApiImplicitParam(name="orgId", value="\u6e20\u9053\u4ee3\u7801", required=true, dataType="string", paramType="query", defaultValue="09577ac9-10db-41c9-8aad-35a75b379310")})
    @RequestMapping(value={"/testLogin"}, method={RequestMethod.GET})
    public WebResponse testLogin(@RequestParam(value="userName") String userName, @RequestParam(value="pwd") String pwd, @RequestParam(value="orgId") String orgId, HttpServletRequest request) {
        MemberVo memberVo = this.loginApi.checkByEmail(userName, pwd, request.getRemoteHost(), orgId);
        request.getSession().setAttribute("member_id", (Object)memberVo.getMember().getId());
        request.getSession().setAttribute("user_id", (Object)memberVo.getUser().getId());
        request.getSession().setAttribute("user_name", (Object)memberVo.getUser().getUsername());
        request.getSession().setAttribute("member_vo_json_str", (Object)JSON.toJSONString((Object)memberVo));
        request.getSession().setAttribute("user_type", (Object)memberVo.getUser().getUserType());
        return WebResponse.SUCCESS((Object)memberVo);
    }

    @RequestMapping(value={"/testTrdApis"}, method={RequestMethod.GET})
    public Object testTrdApis() throws Exception {
        String username = "deli";
        String password = "deli_user_secret";
        String timestamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        String clientSecret = "deli_secret";
        String clientId = "deli";
        String accessToken = "password";
        String sign = clientSecret + timestamp + clientId + username + password + accessToken + clientSecret;
        System.out.println("sign=" + sign);
        sign = MD5Utils.encrypt((String)sign).toUpperCase();
        System.out.println("sign=" + sign);
        String url = "http://localhost/api/oauth/token";
        String data = "grant_type=access_token&client_id=" + clientId + "&username=" + username + "&password=" + password + "&timestamp=" + timestamp + "&sign=" + sign;
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        OkHttpClient okHttpClient = builder.addInterceptor((Interceptor)new /* Unavailable Anonymous Inner Class!! */).build();
        FormBody formBody = new FormBody.Builder().add("grant_type", accessToken).add("client_id", clientId).add("username", username).add("password", password).add("timestamp", timestamp).add("sign", sign).add("client_secret", clientSecret).build();
        Request request = new Request.Builder().url(url).post((RequestBody)formBody).build();
        Response response = okHttpClient.newCall(request).execute();
        JSONObject object = JSON.parseObject((String)response.body().string());
        String access_token = object.getString("access_token");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("subOrderNo", (Object)"8000132575");
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)jsonObject.toString());
        Request request2 = new Request.Builder().addHeader("Content-Type", "application/json; charset=utf-8").url("http://localhost/api/modify/orders/received?access_token=" + access_token + "&timestamp=" + timestamp + "&version=1.0").post(requestBody).build();
        Response response2 = okHttpClient.newCall(request2).execute();
        return response2.body().string();
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }
}

