/*
 * Decompiled with CFR 0.152.
 */
package order.web.utils;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import utils.excel.excelcreate.annotation.ColumnName;
import utils.excel.excelcreate.annotation.Excel;
import utils.excel.excelcreate.vo.ColumnInfoVo;

public class AnnotationUtil {
    public static <T> ColumnInfoVo getExcelData(Class<T> classType, List<T> data) {
        if (!classType.isAnnotationPresent(Excel.class)) {
            throw new RuntimeException("please add @Excel annotation in title");
        }
        AccessibleObject[] declaredFields = classType.getDeclaredFields();
        Field.setAccessible(declaredFields, true);
        ArrayList<String> titles = new ArrayList<String>();
        for (AccessibleObject declaredField : declaredFields) {
            if (!declaredField.isAnnotationPresent(ColumnName.class)) continue;
            titles.add(((Field)declaredField).getAnnotation(ColumnName.class).column());
        }
        if (titles.isEmpty()) {
            throw new RuntimeException("please add @ColumnName annotation in title");
        }
        ArrayList datas = new ArrayList();
        for (T datum : data) {
            ArrayList<Object> dataList = new ArrayList<Object>();
            for (AccessibleObject declaredField : declaredFields) {
                try {
                    if (!declaredField.isAnnotationPresent(ColumnName.class)) continue;
                    dataList.add(((Field)declaredField).get(datum));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            datas.add(dataList);
        }
        return new ColumnInfoVo(titles, datas);
    }
}

