/*
 * Decompiled with CFR 0.152.
 */
package order.web.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.xmlbeans.impl.piccolo.io.FileFormatException;
import utils.Lang;

/*
 * Exception performing whole class analysis ignored.
 */
public class ReadExcel {
    private static final String EXTENSION_XLS = "xls";
    private static final String EXTENSION_XLSX = "xlsx";

    public static List readSingleExcel(InputStream is, String fileName) throws Exception {
        Workbook wb = null;
        ArrayList result = new ArrayList();
        try {
            wb = ReadExcel.getWorkbook((InputStream)is, (String)fileName);
            ReadExcel.handleOneSheetsExcel((Workbook)wb, result);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return result;
    }

    private static Workbook getWorkbook(InputStream is, String fileName) throws IOException {
        HSSFWorkbook workbook = null;
        try {
            if (fileName.endsWith("xls")) {
                workbook = new HSSFWorkbook(is);
            } else if (fileName.endsWith("xlsx")) {
                workbook = new XSSFWorkbook(is);
            }
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            is.close();
        }
        return workbook;
    }

    private static void handleOneSheetsExcel(Workbook wb, List result) {
        ReadExcel.readRows((Sheet)wb.getSheetAt(0), (List)result);
    }

    private static void readRows(Sheet rows, List rowsList) {
        boolean isEmptyRow = true;
        for (Row cells : rows) {
            isEmptyRow = true;
            ArrayList<String> cellList = new ArrayList<String>();
            for (Cell cell : cells) {
                cell.setCellType(1);
                String cellStrVal = cell.getStringCellValue();
                if (Lang.isEmpty((Object)cellStrVal)) {
                    cellStrVal = "";
                }
                isEmptyRow = Lang.isEmpty((Object)cellStrVal) && isEmptyRow;
                cellList.add(cellStrVal);
            }
            if (isEmptyRow) continue;
            rowsList.add(cellList);
        }
    }

    private static void handleSingleSheetExcel(Workbook wb, List result) {
        ReadExcel.readRows((Sheet)wb.getSheetAt(0), (List)result);
    }

    public static void setContentColumnWidth(HSSFSheet sheet, List<Map<String, Integer>> mapList) {
        for (Map<String, Integer> map : mapList) {
            sheet.setColumnWidth(map.get("index").intValue(), map.get("size").intValue());
        }
    }

    public static HSSFCellStyle setContentCellStyle(HSSFWorkbook wb) {
        HSSFCellStyle cellStyle = wb.createCellStyle();
        HSSFFont font = wb.createFont();
        font.setFontName("\u9ed1\u4f53");
        font.setFontHeightInPoints((short)10);
        cellStyle.setFont(font);
        cellStyle.setBorderBottom((short)1);
        cellStyle.setBorderLeft((short)1);
        cellStyle.setBorderRight((short)1);
        cellStyle.setBorderTop((short)1);
        cellStyle.setAlignment((short)2);
        return cellStyle;
    }

    public static void createCellHead(HSSFRow row, HSSFCellStyle cellStyle, HSSFCell cell, List<Map<String, String>> mapList) {
        cell.setCellStyle(cellStyle);
        for (Map<String, String> map : mapList) {
            cell.setCellValue(map.get("name"));
            String indexStr = map.get("index");
            Integer indexInt = Integer.parseInt(indexStr);
            cell = row.createCell(indexInt.intValue());
        }
    }

    public static String setContentCellValue(String value) {
        if (Lang.isEmpty((Object)value)) {
            return "";
        }
        return value;
    }

    private void preReadCheck(String filePath) throws FileNotFoundException, FileFormatException {
        File file = new File(filePath);
        if (!file.exists()) {
            throw new FileNotFoundException("\u4f20\u5165\u7684\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + filePath);
        }
        if (!filePath.endsWith("xls") && !filePath.endsWith("xlsx")) {
            throw new FileFormatException("\u4f20\u5165\u7684\u6587\u4ef6\u4e0d\u662fexcel");
        }
    }
}

