/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Navigate;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.support.LoggingExceptionHandler;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class BatchProcessor
extends ServiceSupport
implements AsyncProcessor,
Navigate<Processor> {
    public static final long DEFAULT_BATCH_TIMEOUT = 1000L;
    public static final int DEFAULT_BATCH_SIZE = 100;
    private static final Logger LOG = LoggerFactory.getLogger(BatchProcessor.class);
    private long batchTimeout = 1000L;
    private int batchSize = 100;
    private int outBatchSize;
    private boolean groupExchanges;
    private boolean batchConsumer;
    private boolean ignoreInvalidExchanges;
    private Predicate completionPredicate;
    private Expression expression;
    private final CamelContext camelContext;
    private final Processor processor;
    private final Collection<Exchange> collection;
    private ExceptionHandler exceptionHandler;
    private final BatchSender sender;

    public BatchProcessor(CamelContext camelContext, Processor processor, Collection<Exchange> collection, Expression expression) {
        ObjectHelper.notNull(camelContext, "camelContext");
        ObjectHelper.notNull(processor, "processor");
        ObjectHelper.notNull(collection, "collection");
        ObjectHelper.notNull(expression, "expression");
        this.camelContext = camelContext;
        this.processor = processor;
        this.collection = collection;
        this.expression = expression;
        this.sender = new BatchSender();
        this.exceptionHandler = new LoggingExceptionHandler(camelContext, this.getClass());
    }

    public String toString() {
        return "BatchProcessor[to: " + this.processor + "]";
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        if (batchSize <= 0) {
            LOG.debug("Disabling batch size, will only be triggered by timeout");
            this.batchSize = Integer.MAX_VALUE;
        } else {
            this.batchSize = batchSize;
        }
    }

    public int getOutBatchSize() {
        return this.outBatchSize;
    }

    public void setOutBatchSize(int outBatchSize) {
        this.outBatchSize = outBatchSize;
    }

    public long getBatchTimeout() {
        return this.batchTimeout;
    }

    public void setBatchTimeout(long batchTimeout) {
        this.batchTimeout = batchTimeout;
    }

    public boolean isGroupExchanges() {
        return this.groupExchanges;
    }

    public void setGroupExchanges(boolean groupExchanges) {
        this.groupExchanges = groupExchanges;
    }

    public boolean isBatchConsumer() {
        return this.batchConsumer;
    }

    public void setBatchConsumer(boolean batchConsumer) {
        this.batchConsumer = batchConsumer;
    }

    public boolean isIgnoreInvalidExchanges() {
        return this.ignoreInvalidExchanges;
    }

    public void setIgnoreInvalidExchanges(boolean ignoreInvalidExchanges) {
        this.ignoreInvalidExchanges = ignoreInvalidExchanges;
    }

    public Predicate getCompletionPredicate() {
        return this.completionPredicate;
    }

    public void setCompletionPredicate(Predicate completionPredicate) {
        this.completionPredicate = completionPredicate;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    @Override
    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        ArrayList<Processor> answer = new ArrayList<Processor>(1);
        answer.add(this.processor);
        return answer;
    }

    @Override
    public boolean hasNext() {
        return this.processor != null;
    }

    private boolean isInBatchCompleted(int num) {
        return num >= this.batchSize;
    }

    private boolean isOutBatchCompleted() {
        if (this.outBatchSize == 0) {
            return true;
        }
        return this.collection.size() > 0 && this.collection.size() >= this.outBatchSize;
    }

    protected void processExchange(Exchange exchange) throws Exception {
        this.processor.process(exchange);
        if (exchange.getException() != null) {
            this.getExceptionHandler().handleException("Error processing aggregated exchange: " + exchange, exchange.getException());
        }
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startServices(this.processor);
        this.sender.start();
    }

    @Override
    protected void doStop() throws Exception {
        this.sender.cancel();
        ServiceHelper.stopServices(this.processor);
        this.collection.clear();
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            int size2;
            if (this.isBatchConsumer() && this.batchSize != (size2 = exchange.getProperty("CamelBatchSize", Integer.class).intValue())) {
                this.batchSize = size2;
                LOG.trace("Using batch consumer completion, so setting batch size to: {}", (Object)this.batchSize);
            }
            if (!this.isValid(exchange)) {
                if (!this.isIgnoreInvalidExchanges()) throw new CamelExchangeException("Exchange is not valid to be used by the BatchProcessor", exchange);
                LOG.debug("Invalid Exchange. This Exchange will be ignored: {}", (Object)exchange);
            } else {
                this.sender.enqueueExchange(exchange);
            }
        }
        catch (Throwable e) {
            exchange.setException(e);
        }
        callback.done(true);
        return true;
    }

    private boolean isValid(Exchange exchange) {
        Object result = null;
        try {
            result = this.expression.evaluate(exchange, Object.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result != null;
    }

    private class BatchSender
    extends Thread {
        private Queue<Exchange> queue;
        private Lock queueLock;
        private boolean exchangeEnqueued;
        private final Queue<String> completionPredicateMatched;
        private Condition exchangeEnqueuedCondition;

        public BatchSender() {
            super(BatchProcessor.this.camelContext.getExecutorServiceManager().resolveThreadName("Batch Sender"));
            this.queueLock = new ReentrantLock();
            this.completionPredicateMatched = new ConcurrentLinkedQueue<String>();
            this.exchangeEnqueuedCondition = this.queueLock.newCondition();
            this.queue = new LinkedList<Exchange>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.queueLock.lock();
            try {
                do {
                    try {
                        if (!this.exchangeEnqueued) {
                            LOG.trace("Waiting for new exchange to arrive or batchTimeout to occur after {} ms.", (Object)BatchProcessor.this.batchTimeout);
                            this.exchangeEnqueuedCondition.await(BatchProcessor.this.batchTimeout, TimeUnit.MILLISECONDS);
                        }
                        String id = null;
                        if (!this.completionPredicateMatched.isEmpty()) {
                            id = this.completionPredicateMatched.poll();
                        }
                        if (id != null || !this.exchangeEnqueued) {
                            if (id != null) {
                                LOG.trace("Collecting exchanges to be aggregated triggered by completion predicate");
                            } else {
                                LOG.trace("Collecting exchanges to be aggregated triggered by batch timeout");
                            }
                            this.drainQueueTo(BatchProcessor.this.collection, BatchProcessor.this.batchSize, id);
                        } else {
                            this.exchangeEnqueued = false;
                            boolean drained = false;
                            while (BatchProcessor.this.isInBatchCompleted(this.queue.size())) {
                                drained = true;
                                this.drainQueueTo(BatchProcessor.this.collection, BatchProcessor.this.batchSize, id);
                            }
                            if (drained) {
                                LOG.trace("Collecting exchanges to be aggregated triggered by new exchanges received");
                            }
                            if (!BatchProcessor.this.isOutBatchCompleted()) continue;
                        }
                        this.queueLock.unlock();
                        try {
                            try {
                                this.sendExchanges();
                            }
                            catch (Throwable t) {
                                BatchProcessor.this.getExceptionHandler().handleException(t);
                            }
                        }
                        finally {
                            this.queueLock.lock();
                        }
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                } while (BatchProcessor.this.isRunAllowed());
            }
            finally {
                this.queueLock.unlock();
            }
        }

        private void drainQueueTo(Collection<Exchange> collection, int batchSize, String exchangeId) {
            Exchange e;
            for (int i = 0; i < batchSize && (e = this.queue.poll()) != null; ++i) {
                try {
                    collection.add(e);
                }
                catch (Exception t) {
                    e.setException(t);
                }
                catch (Throwable t) {
                    BatchProcessor.this.getExceptionHandler().handleException(t);
                }
                if (exchangeId != null && exchangeId.equals(e.getExchangeId())) break;
            }
        }

        public void cancel() {
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void enqueueExchange(Exchange exchange) {
            LOG.debug("Received exchange to be batched: {}", (Object)exchange);
            this.queueLock.lock();
            try {
                boolean matches;
                if (BatchProcessor.this.completionPredicate != null && (matches = BatchProcessor.this.completionPredicate.matches(exchange))) {
                    LOG.trace("Exchange matched completion predicate: {}", (Object)exchange);
                    this.completionPredicateMatched.add(exchange.getExchangeId());
                }
                this.queue.add(exchange);
                this.exchangeEnqueued = true;
                this.exchangeEnqueuedCondition.signal();
            }
            finally {
                this.queueLock.unlock();
            }
        }

        private void sendExchanges() throws Exception {
            Iterator iter = BatchProcessor.this.collection.iterator();
            while (iter.hasNext()) {
                Exchange exchange = (Exchange)iter.next();
                iter.remove();
                try {
                    LOG.debug("Sending aggregated exchange: {}", (Object)exchange);
                    BatchProcessor.this.processExchange(exchange);
                }
                catch (Throwable t) {
                    BatchProcessor.this.getExceptionHandler().handleException("Error processing aggregated exchange: " + exchange, t);
                }
            }
        }
    }
}

