/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize.hessian2;

import com.alibaba.com.caucho.hessian.io.Hessian2Output;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.dubbo.common.serialize.ObjectOutput;
import org.apache.dubbo.common.serialize.hessian2.dubbo.Hessian2FactoryInitializer;

public class Hessian2ObjectOutput
implements ObjectOutput {
    private static ThreadLocal<Hessian2Output> OUTPUT_TL = ThreadLocal.withInitial(() -> {
        Hessian2Output h2o = new Hessian2Output(null);
        h2o.setSerializerFactory(Hessian2FactoryInitializer.getInstance().getSerializerFactory());
        h2o.setCloseStreamOnClose(true);
        return h2o;
    });
    private final Hessian2Output mH2o = OUTPUT_TL.get();

    public Hessian2ObjectOutput(OutputStream os) {
        this.mH2o.init(os);
    }

    public void writeBool(boolean v) throws IOException {
        this.mH2o.writeBoolean(v);
    }

    public void writeByte(byte v) throws IOException {
        this.mH2o.writeInt((int)v);
    }

    public void writeShort(short v) throws IOException {
        this.mH2o.writeInt((int)v);
    }

    public void writeInt(int v) throws IOException {
        this.mH2o.writeInt(v);
    }

    public void writeLong(long v) throws IOException {
        this.mH2o.writeLong(v);
    }

    public void writeFloat(float v) throws IOException {
        this.mH2o.writeDouble((double)v);
    }

    public void writeDouble(double v) throws IOException {
        this.mH2o.writeDouble(v);
    }

    public void writeBytes(byte[] b) throws IOException {
        this.mH2o.writeBytes(b);
    }

    public void writeBytes(byte[] b, int off, int len) throws IOException {
        this.mH2o.writeBytes(b, off, len);
    }

    public void writeUTF(String v) throws IOException {
        this.mH2o.writeString(v);
    }

    public void writeObject(Object obj) throws IOException {
        this.mH2o.writeObject(obj);
    }

    public void flushBuffer() throws IOException {
        this.mH2o.flushBuffer();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.mH2o.getBytesOutputStream();
    }
}

