/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundleplugin;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;

public class BundleInfo {
    private Map<String, Set<Artifact>> m_exportedPackages = new HashMap<String, Set<Artifact>>();

    public void addExportedPackage(String packageName, Artifact artifact) {
        Set<Artifact> artifacts = this.getExportedPackages().get(packageName);
        if (artifacts == null) {
            artifacts = new HashSet<Artifact>();
            this.m_exportedPackages.put(packageName, artifacts);
        }
        artifacts.add(artifact);
    }

    protected Map<String, Set<Artifact>> getExportedPackages() {
        return this.m_exportedPackages;
    }

    public Map<String, Set<Artifact>> getDuplicatedExports() {
        HashMap<String, Set<Artifact>> duplicatedExports = new HashMap<String, Set<Artifact>>();
        for (Map.Entry<String, Set<Artifact>> entry : this.getExportedPackages().entrySet()) {
            Set<Artifact> artifacts = entry.getValue();
            if (artifacts.size() <= 1) continue;
            HashSet<String> artifactKeys = new HashSet<String>();
            String packageName = entry.getKey();
            for (Artifact artifact : artifacts) {
                artifactKeys.add(artifact.getGroupId() + "." + artifact.getArtifactId());
            }
            if (artifactKeys.size() <= 1) continue;
            duplicatedExports.put(packageName, artifacts);
        }
        return duplicatedExports;
    }

    public void merge(BundleInfo bundleInfo) {
        for (Map.Entry<String, Set<Artifact>> entry : bundleInfo.getExportedPackages().entrySet()) {
            String packageName = entry.getKey();
            Set<Artifact> artifacts = entry.getValue();
            Set<Artifact> artifactsWithPackage = this.getExportedPackages().get(packageName);
            if (artifactsWithPackage == null) {
                artifactsWithPackage = new HashSet<Artifact>();
                this.getExportedPackages().put(packageName, artifactsWithPackage);
            }
            artifactsWithPackage.addAll(artifacts);
        }
    }
}

