/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.junit;

import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.ThreadContextHolder;
import org.apache.logging.log4j.junit.UsingAnyThreadContext;
import org.apache.logging.log4j.junit.UsingThreadContextMap;
import org.apache.logging.log4j.junit.UsingThreadContextStack;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

class ThreadContextExtension
implements BeforeEachCallback,
AfterEachCallback {
    ThreadContextExtension() {
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        ThreadContextHolder holder;
        Class testClass = context.getRequiredTestClass();
        if (testClass.isAnnotationPresent(UsingAnyThreadContext.class)) {
            holder = new ThreadContextHolder(true, true);
            ThreadContext.clearAll();
        } else if (testClass.isAnnotationPresent(UsingThreadContextMap.class)) {
            holder = new ThreadContextHolder(true, false);
            ThreadContext.clearMap();
        } else if (testClass.isAnnotationPresent(UsingThreadContextStack.class)) {
            holder = new ThreadContextHolder(false, true);
            ThreadContext.clearStack();
        } else {
            return;
        }
        this.getStore(context).put(ThreadContextHolder.class, (Object)holder);
    }

    public void afterEach(ExtensionContext context) throws Exception {
        ThreadContextHolder holder = (ThreadContextHolder)this.getStore(context).get(ThreadContextHolder.class, ThreadContextHolder.class);
        if (holder != null) {
            holder.restore();
        }
    }

    private ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{this.getClass(), context.getRequiredTestInstance()}));
    }
}

