/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import java.util.Locale;
import org.apache.logging.log4j.junit.Mutable;
import org.apache.logging.log4j.message.MessageFormatMessage;
import org.apache.logging.log4j.util.Constants;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.ResourceAccessMode;
import org.junit.jupiter.api.parallel.ResourceLock;

@ResourceLock(value="java.util.Locale.default", mode=ResourceAccessMode.READ)
public class MessageFormatMessageTest {
    private static final String SPACE = Constants.JAVA_MAJOR_VERSION < 9 ? " " : "\u00a0";
    private static final int LOOP_CNT = 500;
    String[] array = new String[500];

    @Test
    public void testNoArgs() {
        String testMsg = "Test message {0}";
        MessageFormatMessage msg = new MessageFormatMessage("Test message {0}", (Object[])null);
        String result = msg.getFormattedMessage();
        String expected = "Test message {0}";
        Assertions.assertEquals((Object)expected, (Object)result);
        Object array = null;
        msg = new MessageFormatMessage("Test message {0}", new Object[]{array, null});
        result = msg.getFormattedMessage();
        expected = "Test message null";
        Assertions.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testOneStringArg() {
        String testMsg = "Test message {0}";
        MessageFormatMessage msg = new MessageFormatMessage("Test message {0}", new Object[]{"Apache"});
        String result = msg.getFormattedMessage();
        String expected = "Test message Apache";
        Assertions.assertEquals((Object)"Test message Apache", (Object)result);
    }

    @Test
    public void testOneIntArgLocaleUs() {
        String testMsg = "Test message {0,number,currency}";
        MessageFormatMessage msg = new MessageFormatMessage(Locale.US, "Test message {0,number,currency}", new Object[]{1234567890});
        String result = msg.getFormattedMessage();
        String expected = "Test message $1,234,567,890.00";
        Assertions.assertEquals((Object)"Test message $1,234,567,890.00", (Object)result);
    }

    @Test
    public void testOneIntArgLocaleFrance() {
        String testMsg = "Test message {0,number,currency}";
        MessageFormatMessage msg = new MessageFormatMessage(Locale.FRANCE, "Test message {0,number,currency}", new Object[]{1234567890});
        String result = msg.getFormattedMessage();
        String expected = "Test message 1\u00a0234\u00a0567\u00a0890,00" + SPACE + "\u20ac";
        Assertions.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testException() {
        String testMsg = "Test message {0}";
        MessageFormatMessage msg = new MessageFormatMessage("Test message {0}", new Object[]{"Apache", new NullPointerException("Null")});
        String result = msg.getFormattedMessage();
        String expected = "Test message Apache";
        Assertions.assertEquals((Object)"Test message Apache", (Object)result);
        Throwable t = msg.getThrowable();
        Assertions.assertNotNull((Object)t, (String)"No Throwable");
    }

    @Test
    public void testUnsafeWithMutableParams() {
        String testMsg = "Test message {0}";
        Mutable param = new Mutable().set("abc");
        MessageFormatMessage msg = new MessageFormatMessage("Test message {0}", new Object[]{param});
        param.set("XYZ");
        String actual = msg.getFormattedMessage();
        Assertions.assertEquals((Object)"Test message XYZ", (Object)actual, (String)"Expected most recent param value");
    }

    @Test
    public void testSafeAfterGetFormattedMessageIsCalled() {
        String testMsg = "Test message {0}";
        Mutable param = new Mutable().set("abc");
        MessageFormatMessage msg = new MessageFormatMessage("Test message {0}", new Object[]{param});
        msg.getFormattedMessage();
        param.set("XYZ");
        String actual = msg.getFormattedMessage();
        Assertions.assertEquals((Object)"Test message abc", (Object)actual, (String)"Should use initial param value");
    }
}

