/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import org.apache.logging.log4j.junit.Mutable;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ParameterizedMessageTest {
    @Test
    public void testNoArgs() {
        String testMsg = "Test message {}";
        ParameterizedMessage msg = new ParameterizedMessage("Test message {}", (Object[])null);
        String result = msg.getFormattedMessage();
        Assertions.assertEquals((Object)"Test message {}", (Object)result);
        Object[] array = null;
        msg = new ParameterizedMessage("Test message {}", array, null);
        result = msg.getFormattedMessage();
        Assertions.assertEquals((Object)"Test message {}", (Object)result);
    }

    @Test
    public void testZeroLength() {
        String testMsg = "";
        ParameterizedMessage msg = new ParameterizedMessage("", new Object[]{"arg"});
        String result = msg.getFormattedMessage();
        Assertions.assertEquals((Object)"", (Object)result);
        Object[] array = null;
        msg = new ParameterizedMessage("", array, null);
        result = msg.getFormattedMessage();
        Assertions.assertEquals((Object)"", (Object)result);
    }

    @Test
    public void testOneCharLength() {
        String testMsg = "d";
        ParameterizedMessage msg = new ParameterizedMessage("d", new Object[]{"arg"});
        String result = msg.getFormattedMessage();
        Assertions.assertEquals((Object)"d", (Object)result);
        Object[] array = null;
        msg = new ParameterizedMessage("d", array, null);
        result = msg.getFormattedMessage();
        Assertions.assertEquals((Object)"d", (Object)result);
    }

    @Test
    public void testFormat3StringArgs() {
        String testMsg = "Test message {}{} {}";
        Object[] args = new String[]{"a", "b", "c"};
        String result = ParameterizedMessage.format((String)"Test message {}{} {}", (Object[])args);
        Assertions.assertEquals((Object)"Test message ab c", (Object)result);
    }

    @Test
    public void testFormatNullArgs() {
        String testMsg = "Test message {} {} {} {} {} {}";
        Object[] args = new String[]{"a", null, "c", null, null, null};
        String result = ParameterizedMessage.format((String)"Test message {} {} {} {} {} {}", (Object[])args);
        Assertions.assertEquals((Object)"Test message a null c null null null", (Object)result);
    }

    @Test
    public void testFormatStringArgsIgnoresSuperfluousArgs() {
        String testMsg = "Test message {}{} {}";
        Object[] args = new String[]{"a", "b", "c", "unnecessary", "superfluous"};
        String result = ParameterizedMessage.format((String)"Test message {}{} {}", (Object[])args);
        Assertions.assertEquals((Object)"Test message ab c", (Object)result);
    }

    @Test
    public void testFormatStringArgsWithEscape() {
        String testMsg = "Test message \\{}{} {}";
        Object[] args = new String[]{"a", "b", "c"};
        String result = ParameterizedMessage.format((String)"Test message \\{}{} {}", (Object[])args);
        Assertions.assertEquals((Object)"Test message {}a b", (Object)result);
    }

    @Test
    public void testFormatStringArgsWithTrailingEscape() {
        String testMsg = "Test message {}{} {}\\";
        Object[] args = new String[]{"a", "b", "c"};
        String result = ParameterizedMessage.format((String)"Test message {}{} {}\\", (Object[])args);
        Assertions.assertEquals((Object)"Test message ab c\\", (Object)result);
    }

    @Test
    public void testFormatStringArgsWithTrailingText() {
        String testMsg = "Test message {}{} {}Text";
        Object[] args = new String[]{"a", "b", "c"};
        String result = ParameterizedMessage.format((String)"Test message {}{} {}Text", (Object[])args);
        Assertions.assertEquals((Object)"Test message ab cText", (Object)result);
    }

    @Test
    public void testFormatStringArgsWithTrailingEscapedEscape() {
        String testMsg = "Test message {}{} {}\\\\";
        Object[] args = new String[]{"a", "b", "c"};
        String result = ParameterizedMessage.format((String)"Test message {}{} {}\\\\", (Object[])args);
        Assertions.assertEquals((Object)"Test message ab c\\\\", (Object)result);
    }

    @Test
    public void testFormatStringArgsWithEscapedEscape() {
        String testMsg = "Test message \\\\{}{} {}";
        Object[] args = new String[]{"a", "b", "c"};
        String result = ParameterizedMessage.format((String)"Test message \\\\{}{} {}", (Object[])args);
        Assertions.assertEquals((Object)"Test message \\ab c", (Object)result);
    }

    @Test
    public void testSafeWithMutableParams() {
        String testMsg = "Test message {}";
        Mutable param = new Mutable().set("abc");
        ParameterizedMessage msg = new ParameterizedMessage("Test message {}", (Object)param);
        param.set("XYZ");
        String actual = msg.getFormattedMessage();
        Assertions.assertEquals((Object)"Test message XYZ", (Object)actual, (String)"Should use current param value");
        param.set("000");
        String after = msg.getFormattedMessage();
        Assertions.assertEquals((Object)"Test message XYZ", (Object)after, (String)"Should not change after rendered once");
    }
}

